/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.upgrade_aquatic.client.model.LionfishModel;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Lionfish;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.other.UAModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LionfishRenderer
extends MobRenderer<Lionfish, LionfishModel<Lionfish>> {
    public LionfishRenderer(EntityRendererProvider.Context context) {
        super(context, new LionfishModel(context.bakeLayer(UAModelLayers.LIONFISH)), 0.45f);
    }

    public ResourceLocation getTextureLocation(Lionfish entity) {
        return UpgradeAquatic.location("textures/entity/lionfish.png");
    }

    protected void setupRotations(Lionfish entityLiving, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)entityLiving, matrixStack, ageInTicks, rotationYaw, partialTicks, scale);
        float f = 4.0f * Mth.sin((float)(0.6f * ageInTicks));
        matrixStack.mulPose(Axis.YP.rotationDegrees(f));
        if (!entityLiving.isInWater()) {
            matrixStack.translate(0.1f, 0.1f, -0.1f);
            matrixStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

