/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.blueprint.client.EntitySkinHelper;
import com.teamabnormals.upgrade_aquatic.client.model.NautilusModel;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Nautilus;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.other.UAModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NautilusRenderer
extends MobRenderer<Nautilus, NautilusModel<Nautilus>> {
    private static final EntitySkinHelper<Nautilus> SKIN_HELPER = EntitySkinHelper.create((String)"upgrade_aquatic", (String)"textures/entity/nautilus", (String)"nautilus", helper -> {
        helper.putSkins("smelly", new String[]{"smelly", "thefaceofgaming"});
        helper.putSkins("mca", new String[]{"abnormal", "abnautilus", "abnortilus", "mca"});
        helper.putSkins("five", new String[]{"five", "epic"});
        helper.putSkins("cell", new String[]{"neon membrane", "cell membrane", "cell"});
        helper.putSkins("tb", new String[]{"tb"});
        helper.putSkins("bagel", new String[]{"bagel", "shy guy", "legobagel"});
        helper.putSkins("sadcat", new String[]{"sadcat"});
        helper.putSkins("cameron", new String[]{"cameron", "cam", "cringe"});
        helper.putSkins("snake_block", new String[]{"snake", "snautilus", "snakeblock", "snake block"});
        helper.putSkins("snail", new String[]{"snail", "snail nautilus"});
    });

    public NautilusRenderer(EntityRendererProvider.Context context) {
        super(context, new NautilusModel(context.bakeLayer(UAModelLayers.NAUTILUS)), 0.5f);
    }

    public ResourceLocation getTextureLocation(Nautilus nautilus) {
        return SKIN_HELPER.getSkinForEntityOrElse((Entity)nautilus, UpgradeAquatic.location("textures/entity/nautilus/nautilus.png"));
    }

    protected void setupRotations(Nautilus nautilus, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)nautilus, matrixStack, ageInTicks, rotationYaw, partialTicks, scale);
        float f = 0.3f * Mth.sin((float)(0.6f * ageInTicks));
        matrixStack.mulPose(Axis.YP.rotationDegrees(f));
        if (!nautilus.isInWater() && !nautilus.isEyeInFluid(FluidTags.WATER)) {
            matrixStack.translate(0.2f, 0.14f, 0.0f);
            matrixStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

