/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.upgrade_aquatic.client.model.PerchModel;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Perch;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.other.UAModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class PerchRenderer
extends MobRenderer<Perch, PerchModel<Perch>> {
    private static final ResourceLocation PERCH_LOCATION = UpgradeAquatic.location("textures/entity/perch.png");

    public PerchRenderer(EntityRendererProvider.Context context) {
        super(context, new PerchModel(context.bakeLayer(UAModelLayers.PERCH)), 0.3f);
    }

    public ResourceLocation getTextureLocation(Perch entity) {
        return PERCH_LOCATION;
    }

    protected void setupRotations(Perch entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, scale);
        float f = 4.3f * Mth.sin((float)(0.6f * ageInTicks));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(f));
        if (!entityLiving.isInWater()) {
            matrixStackIn.translate(0.1f, 0.1f, -0.1f);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

