/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block;

import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import com.teamabnormals.upgrade_aquatic.core.other.tags.UABlockTags;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PickerelweedDoublePlantBlock
extends Block
implements BonemealableBlock,
SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty FAKE_WATERLOGGED = BooleanProperty.create((String)"fake_waterlogged");

    public PickerelweedDoublePlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState p_53517_, BlockGetter p_53518_, BlockPos p_53519_, CollisionContext p_53520_) {
        Vec3 vec3 = p_53517_.getOffset(p_53518_, p_53519_);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)UABlocks.PICKERELWEED.get());
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        if (!(entity instanceof Pike)) {
            entity.makeStuckInBlock(state, new Vec3(0.75, 0.75, 0.75));
        }
    }

    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.is(UABlockTags.PICKERELWEED_PLACEABLE);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.getValue(HALF);
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
            if (doubleblockhalf == DoubleBlockHalf.UPPER && !((Boolean)stateIn.getValue((Property)FAKE_WATERLOGGED)).booleanValue()) {
                stateIn = (BlockState)stateIn.setValue((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(true));
                if (worldIn.getBlockState(currentPos.below()).hasProperty((Property)FAKE_WATERLOGGED)) {
                    worldIn.setBlock(currentPos.below(), (BlockState)worldIn.getBlockState(currentPos.below()).setValue((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
                }
            } else if (doubleblockhalf == DoubleBlockHalf.LOWER && !((Boolean)stateIn.getValue((Property)FAKE_WATERLOGGED)).booleanValue()) {
                stateIn = (BlockState)stateIn.setValue((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(true));
                if (worldIn.getBlockState(currentPos.above()).hasProperty((Property)FAKE_WATERLOGGED)) {
                    worldIn.setBlock(currentPos.above(), (BlockState)worldIn.getBlockState(currentPos.above()).setValue((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
                }
            }
        }
        if (facing.getAxis() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.is((Block)this) && facingState.getValue(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : stateIn;
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockPos blockpos = context.getClickedPos();
        return blockpos.getY() < context.getLevel().getMaxBuildHeight() - 1 && context.getLevel().getBlockState(blockpos.above()).canBeReplaced(context) ? (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.is(FluidTags.WATER) && ifluidstate.getAmount() == 8))).setValue((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.is(FluidTags.WATER) && ifluidstate.getAmount() == 8)) : null;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.setBlock(pos.above(), (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.UPPER) {
            return this.isValidGround(worldIn.getBlockState(pos.below()), (BlockGetter)worldIn, pos);
        }
        BlockState blockstate = worldIn.getBlockState(pos.below());
        if (state.getBlock() != this) {
            this.isValidGround(worldIn.getBlockState(pos.below()), (BlockGetter)worldIn, pos);
        }
        return blockstate.is((Block)this) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    public void placeAt(LevelAccessor p_196390_1_, BlockPos p_196390_2_, int flags) {
        FluidState ifluidstate = p_196390_1_.getFluidState(p_196390_2_);
        FluidState ifluidstateUp = p_196390_1_.getFluidState(p_196390_2_.above());
        boolean applyFakeWaterLogging = ifluidstate.is(FluidTags.WATER) && ifluidstate.getAmount() == 8 || ifluidstateUp.is(FluidTags.WATER) && ifluidstateUp.getAmount() == 8;
        p_196390_1_.setBlock(p_196390_2_, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.is(FluidTags.WATER) && ifluidstate.getAmount() == 8))).setValue((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(applyFakeWaterLogging)), flags);
        p_196390_1_.setBlock(p_196390_2_.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstateUp.is(FluidTags.WATER) && ifluidstateUp.getAmount() == 8))).setValue((Property)FAKE_WATERLOGGED, (Comparable)Boolean.valueOf(applyFakeWaterLogging)), flags);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, WATERLOGGED, FAKE_WATERLOGGED});
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? 0 : 60;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public BlockBehaviour.OffsetType getOffsetType() {
        return BlockBehaviour.OffsetType.XZ;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)pos.getZ());
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        if (!worldIn.isClientSide) {
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos = pos;
                BlockState blockstate = ((Block)UABlocks.PICKERELWEED.get()).defaultBlockState();
                for (int j = 0; j < i / 16; ++j) {
                    if (Block.isShapeFullBlock((VoxelShape)worldIn.getBlockState(blockpos = blockpos.offset(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).getCollisionShape((BlockGetter)worldIn, blockpos))) continue block0;
                }
                if (!blockstate.canSurvive((LevelReader)worldIn, blockpos) || !worldIn.getBlockState(blockpos).canBeReplaced() || !(rand.nextFloat() <= 0.1f)) continue;
                BlockState blockstate1 = worldIn.getBlockState(blockpos);
                if (blockstate1.getFluidState().is(FluidTags.WATER) && worldIn.getFluidState(blockpos).getAmount() == 8) {
                    worldIn.setBlock(blockpos, (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                    continue;
                }
                worldIn.setBlock(blockpos, (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.isClientSide) {
            if (player.getAbilities().instabuild) {
                PickerelweedDoublePlantBlock.removeBottomHalf(worldIn, pos, state, player);
            } else {
                PickerelweedDoublePlantBlock.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, Blocks.AIR.defaultBlockState(), te, stack);
    }

    protected static void removeBottomHalf(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER) {
            BlockPos blockpos2 = pos.below();
            BlockState blockstate2 = world.getBlockState(blockpos2);
            if (blockstate2.getBlock() == state.getBlock() && blockstate2.getValue(HALF) == DoubleBlockHalf.LOWER) {
                world.setBlock(blockpos2, world.getFluidState(blockpos2).getAmount() == 8 ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 51);
                world.levelEvent(player, 2001, blockpos2, Block.getId((BlockState)blockstate2));
            }
        } else if (doubleblockhalf == DoubleBlockHalf.LOWER && (blockstate = world.getBlockState(blockpos = pos.above())).getBlock() == state.getBlock() && blockstate.getValue(HALF) == DoubleBlockHalf.UPPER) {
            world.setBlock(blockpos, world.getFluidState(blockpos).getAmount() == 8 ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 51);
            world.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
    }
}

