/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block.coralstone;

import com.teamabnormals.upgrade_aquatic.common.block.coralstone.CoralstoneBlock;
import com.teamabnormals.upgrade_aquatic.core.other.UADataMaps;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CoralWallFanBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.Tags;

public class CoralstoneSlabBlock
extends SlabBlock {
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    @Nullable
    private final Block[] growableCoralBlocks;

    public CoralstoneSlabBlock(BlockBehaviour.Properties properties, @Nullable Block[] growableCoralBlocks) {
        super(properties);
        this.growableCoralBlocks = growableCoralBlocks;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.isAreaLoaded(pos, 3)) {
            return;
        }
        Block block = state.getBlock();
        if (this.growableCoralBlocks == null && block != UABlocks.DEAD_CORALSTONE_SLAB.get()) {
            CoralstoneBlock.tickConversion(UADataMaps.CoralstoneConversions::coralstoneSlab, state, worldIn, pos, random);
        }
        if (this.growableCoralBlocks != null && random.nextFloat() < 0.12f && ((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            Direction randDirection = this.growableCoralBlocks.length > 3 ? Direction.getRandom((RandomSource)random) : Direction.from3DDataValue((int)(random.nextInt(5) + 1));
            BlockPos growPos = pos.relative(randDirection);
            FluidState fluidState = worldIn.getBlockState(growPos).getFluidState();
            if (state.getValue((Property)TYPE) == SlabType.BOTTOM) {
                if (this.isValidPosToGrow((Level)worldIn, pos.relative(Direction.DOWN), fluidState) && this.growableCoralBlocks.length > 3) {
                    worldIn.setBlock(pos.relative(Direction.DOWN), this.growableCoralBlocks[3].defaultBlockState(), 2);
                }
            } else if (state.getValue((Property)TYPE) == SlabType.TOP) {
                if (this.isValidPosToGrow((Level)worldIn, pos.relative(Direction.UP), fluidState)) {
                    if (random.nextBoolean()) {
                        worldIn.setBlock(pos.relative(Direction.UP), this.growableCoralBlocks[0].defaultBlockState(), 2);
                    } else {
                        worldIn.setBlock(pos.relative(Direction.UP), this.growableCoralBlocks[1].defaultBlockState(), 2);
                    }
                }
            } else if (state.getValue((Property)TYPE) == SlabType.DOUBLE && this.isValidPosToGrow((Level)worldIn, growPos, fluidState)) {
                if (randDirection.get3DDataValue() > 1) {
                    worldIn.setBlock(growPos, (BlockState)this.growableCoralBlocks[2].defaultBlockState().setValue((Property)CoralWallFanBlock.FACING, (Comparable)randDirection), 2);
                } else if (randDirection.get3DDataValue() == 1) {
                    if (random.nextBoolean()) {
                        worldIn.setBlock(growPos, this.growableCoralBlocks[1].defaultBlockState(), 2);
                    } else {
                        worldIn.setBlock(growPos, this.growableCoralBlocks[0].defaultBlockState(), 2);
                    }
                } else {
                    worldIn.setBlock(growPos, this.growableCoralBlocks[3].defaultBlockState(), 2);
                }
            }
        }
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.isClientSide && (flag = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != worldIn.hasNeighborSignal(pos)) {
            worldIn.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Tags.Items.TOOLS_SHEAR) && state.getBlock() != UABlocks.CORALSTONE_SLAB.get()) {
            BlockState newState = ((Block)UABlocks.CORALSTONE_SLAB.get()).defaultBlockState();
            level.playSound(null, pos, SoundEvents.MOOSHROOM_SHEAR, SoundSource.PLAYERS, 1.0f, 0.8f);
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.setBlock(pos, (BlockState)((BlockState)newState.setValue((Property)TYPE, (Comparable)((SlabType)state.getValue((Property)TYPE)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED))), 2);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, WATERLOGGED, POWERED});
    }

    private boolean isValidPosToGrow(Level world, BlockPos pos, FluidState fluidState) {
        return world.getBlockState(pos).canBeReplaced() && fluidState.getAmount() >= 8 && fluidState.is(FluidTags.WATER);
    }
}

