/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.jellyfish;

import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.CassiopeaJellyfish;
import java.util.EnumSet;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;

public class CassiopeaHideInSeagrassGoal
extends Goal {
    private final CassiopeaJellyfish jellyfish;
    private int ticksPassed;
    private int ticksTillEnd;

    public CassiopeaHideInSeagrassGoal(CassiopeaJellyfish jellyfish) {
        this.jellyfish = jellyfish;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.jellyfish.isEyeInFluid(FluidTags.WATER) && this.isInSeagrass() && !this.jellyfish.hasHideCooldown();
    }

    public void start() {
        this.ticksPassed = 0;
        this.ticksTillEnd = this.jellyfish.getRandom().nextInt(40) + 80;
        this.jellyfish.hideCooldown = this.jellyfish.getRandom().nextInt(200) + 200;
    }

    public void tick() {
        ++this.ticksPassed;
    }

    public boolean canContinueToUse() {
        return this.jellyfish.isEyeInFluid(FluidTags.WATER) && this.isInSeagrass() && this.ticksPassed < this.ticksTillEnd;
    }

    private boolean isInSeagrass() {
        return this.jellyfish.getBlockStateOn().getBlock() == Blocks.SEAGRASS || this.jellyfish.getBlockStateOn().getBlock() == Blocks.TALL_SEAGRASS;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

