/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike;

import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import java.util.EnumSet;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class PikeTemptGoal
extends Goal {
    private static final TargetingConditions CAN_FOLLOW = TargetingConditions.forNonCombat().range(10.0).ignoreLineOfSight();
    private final Pike pike;
    private Player tempter;
    private int cooldown;

    public PikeTemptGoal(Pike pike) {
        this.pike = pike;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.tempter = this.pike.level().getNearestPlayer(CAN_FOLLOW, (LivingEntity)this.pike);
        if (this.tempter == null) {
            return false;
        }
        return this.isTemptedBy(this.tempter.getMainHandItem()) || this.isTemptedBy(this.tempter.getOffhandItem());
    }

    public void stop() {
        this.tempter = null;
        this.pike.getNavigation().stop();
        this.cooldown = 100;
    }

    public void tick() {
        this.pike.getLookControl().setLookAt((Entity)this.tempter, (float)this.pike.getMaxHeadYRot() + 20.0f, (float)this.pike.getMaxHeadXRot());
        if (this.pike.distanceToSqr((Entity)this.tempter) < 6.25) {
            this.pike.getNavigation().stop();
        } else {
            this.pike.getNavigation().moveTo((Entity)this.tempter, 1.0);
        }
    }

    private boolean isTemptedBy(ItemStack stack) {
        return stack.is(ItemTags.FISHES);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

