/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher;

import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.EntityUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.common.entity.projectile.SonarWave;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAPlayableEndimations;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;

public class ThrasherFireSonarGoal
extends Goal {
    public Thrasher thrasher;
    private int turnTicks;
    private int sonarTicks;
    private int sonarFireDuration;
    private float originalYaw;
    private float originalPitch;
    @Nullable
    private SonarPhase sonarPhase;

    public ThrasherFireSonarGoal(Thrasher thrasher) {
        this.thrasher = thrasher;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        return SonarPhase.shouldContinueExecutingPhase(null, this.thrasher, this.sonarTicks) && this.thrasher.getTicksSinceLastSonarFire() > 55 && this.thrasher.isNoEndimationPlaying();
    }

    public boolean canContinueToUse() {
        boolean shouldContinue = SonarPhase.shouldContinueExecutingPhase(this.sonarPhase, this.thrasher, this.sonarTicks);
        return shouldContinue && (this.sonarPhase != SonarPhase.FIRE || this.thrasher.getTarget() == null && (this.sonarTicks == 0 || this.sonarTicks == this.sonarFireDuration) || this.sonarTicks < this.sonarFireDuration);
    }

    public void start() {
        this.sonarPhase = SonarPhase.TURN;
        this.sonarFireDuration = this.thrasher.getRandom().nextInt(3) * 5 + 30;
    }

    public void stop() {
        this.sonarFireDuration = 0;
        this.sonarTicks = 0;
        this.turnTicks = 0;
        this.sonarPhase = null;
        this.thrasher.setPossibleDetectionPoint(Optional.empty());
        ((Thrasher.ThrasherLookController)this.thrasher.getLookControl()).setTurningForSonar(false);
    }

    public void tick() {
        this.thrasher.getNavigation().stop();
        if (this.sonarPhase == SonarPhase.TURN) {
            ++this.turnTicks;
            Optional<BlockPos> optional = this.thrasher.getPossibleDetectionPoint();
            if (optional.isPresent()) {
                BlockPos pos = optional.get();
                ((Thrasher.ThrasherLookController)this.thrasher.getLookControl()).setTurningForSonar(true);
                this.thrasher.getLookControl().setLookAt((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 90.0f, 90.0f);
                if (this.turnTicks > 50) {
                    this.sonarPhase = SonarPhase.FIRE;
                }
            }
        } else {
            if (this.sonarTicks == 0 && SonarPhase.shouldContinueExecutingPhase(SonarPhase.FIRE, this.thrasher, this.sonarTicks)) {
                this.originalYaw = this.thrasher.getYRot();
                this.originalPitch = this.thrasher.getXRot();
                NetworkUtil.setPlayingAnimation((Entity)this.thrasher, (PlayableEndimation)UAPlayableEndimations.THRASHER_SONAR_FIRE);
                this.thrasher.playSound(this.thrasher.getSonarFireSound(), 3.5f, 1.0f);
            }
            ++this.sonarTicks;
            this.stablilizeDirection();
            if (this.sonarTicks % 5 == 0 && this.sonarTicks < this.sonarFireDuration) {
                SonarWave sonarWave = (SonarWave)((EntityType)UAEntityTypes.SONAR_WAVE.get()).create(this.thrasher.level());
                sonarWave.fireSonarWave(this.thrasher);
                this.thrasher.level().addFreshEntity((Entity)sonarWave);
            }
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private void stablilizeDirection() {
        this.thrasher.yRotO = this.originalYaw;
        this.thrasher.xRotO = this.originalPitch;
        this.thrasher.setYRot(this.originalYaw);
        this.thrasher.setXRot(this.originalPitch);
    }

    static enum SonarPhase {
        TURN(null),
        FIRE((thrasher, sonarTicks) -> sonarTicks <= 15 || EntityUtil.rayTrace((Entity)thrasher, (double)32.0, (float)1.0f).getType() == HitResult.Type.MISS);

        @Nullable
        private final BiPredicate<Thrasher, Integer> phaseCondition;

        private SonarPhase(BiPredicate<Thrasher, Integer> phaseCondition) {
            this.phaseCondition = phaseCondition;
        }

        public static boolean shouldContinueExecutingPhase(@Nullable SonarPhase phase, Thrasher thrasher, int sonarTicks) {
            boolean defaultCondition;
            boolean bl = defaultCondition = !thrasher.isStunned() && thrasher.isInWater() && thrasher.getPassengers().isEmpty() && thrasher.getTarget() == null && thrasher.getPossibleDetectionPoint() != null && thrasher.level().getBlockState(thrasher.blockPosition().below()).getBlock() == Blocks.WATER;
            if (phase == null) {
                return defaultCondition;
            }
            return defaultCondition && (phase.phaseCondition == null || phase.phaseCondition.test(thrasher, sonarTicks));
        }
    }
}

