/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher;

import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.EntityUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.core.registry.UAPlayableEndimations;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.phys.HitResult;

public class ThrasherGrabGoal
extends MeleeAttackGoal {
    private final Thrasher thrasher;

    public ThrasherGrabGoal(Thrasher thrasher, double speedIn, boolean useLongMemory) {
        super((PathfinderMob)thrasher, speedIn, useLongMemory);
        this.thrasher = thrasher;
    }

    public boolean canUse() {
        LivingEntity attackTarget = this.thrasher.getTarget();
        if (attackTarget != null && attackTarget.isPassenger() && attackTarget.getVehicle() instanceof Thrasher) {
            return false;
        }
        return !this.thrasher.isStunned() && super.canUse() && this.thrasher.getPassengers().isEmpty();
    }

    public boolean canContinueToUse() {
        LivingEntity attackTarget = this.thrasher.getTarget();
        if (attackTarget != null && attackTarget.isPassenger() && attackTarget.getVehicle() instanceof Thrasher) {
            return false;
        }
        return !this.thrasher.isStunned() && super.canContinueToUse() && this.thrasher.getPassengers().isEmpty();
    }

    protected void checkAndPerformAttack(LivingEntity enemy) {
        boolean isGrabBlocked;
        if (this.canPerformAttack(enemy) && this.thrasher.isNoEndimationPlaying()) {
            NetworkUtil.setPlayingAnimation((Entity)this.thrasher, (PlayableEndimation)UAPlayableEndimations.THRASHER_SNAP_AT_PRAY);
        }
        boolean bl = isGrabBlocked = EntityUtil.rayTrace((Entity)this.thrasher, (double)enemy.position().distanceTo(this.thrasher.position()), (float)1.0f).getType() == HitResult.Type.BLOCK;
        if (this.canPerformAttack(enemy) && !isGrabBlocked) {
            enemy.startRiding((Entity)this.thrasher, true);
            this.thrasher.setTarget(null);
        }
    }
}

