/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal;

import com.teamabnormals.blueprint.common.entity.BucketableWaterAnimal;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.core.UAConfig;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Nautilus
extends BucketableWaterAnimal {
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.defineId(Nautilus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FLEEING = SynchedEntityData.defineId(Nautilus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Nautilus(EntityType<? extends Nautilus> type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new MoveHelperController(this);
    }

    public Nautilus(Level world, double posX, double posY, double posZ) {
        this((EntityType<? extends Nautilus>)((EntityType)UAEntityTypes.NAUTILUS.get()), world);
        this.setPos(posX, posY, posZ);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 18.0);
    }

    public static boolean checkNautilusSpawnRules(EntityType<? extends PathfinderMob> entityType, LevelAccessor level, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.getY() <= (Integer)UAConfig.COMMON.nautilusMaxSpawnHeight.get() && level.getFluidState(pos.below()).is(FluidTags.WATER) && level.getBlockState(pos.above()).is(Blocks.WATER);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.65));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal<Player>(this, (PathfinderMob)this, Player.class, 9.0f, 1.5, 1.2, EntitySelector.NO_SPECTATORS::test){

            public void start() {
                ((Nautilus)this.mob).setFleeing(true);
                super.start();
            }

            public void stop() {
                ((Nautilus)this.mob).setFleeing(false);
                super.stop();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal<Squid>(this, (PathfinderMob)this, Squid.class, 9.0f, 1.5, 1.2, EntitySelector.NO_SPECTATORS::test){

            public void start() {
                ((Nautilus)this.mob).setFleeing(true);
                super.start();
            }

            public void stop() {
                ((Nautilus)this.mob).setFleeing(false);
                super.stop();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal<Thrasher>(this, (PathfinderMob)this, Thrasher.class, 9.0f, 1.5, 1.2, EntitySelector.NO_SPECTATORS::test){

            public void start() {
                ((Nautilus)this.mob).setFleeing(true);
                super.start();
            }

            public void stop() {
                ((Nautilus)this.mob).setFleeing(false);
                super.stop();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new SwimGoal(this));
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.COD_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.TURTLE_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.TURTLE_HURT;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.FISH_SWIM;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOVING, (Object)false);
        builder.define(FLEEING, (Object)false);
    }

    public boolean isFleeing() {
        return (Boolean)this.entityData.get(FLEEING);
    }

    public void setFleeing(boolean p_203706_1_) {
        this.entityData.set(FLEEING, (Object)p_203706_1_);
    }

    public boolean isMoving() {
        return (Boolean)this.entityData.get(MOVING);
    }

    public void setMoving(boolean p_203706_1_) {
        this.entityData.set(MOVING, (Object)p_203706_1_);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Moving", this.isMoving());
        compound.putBoolean("Fleeing", this.isMoving());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setMoving(compound.getBoolean("Moving"));
        this.setMoving(compound.getBoolean("Fleeing"));
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)UAItems.NAUTILUS_BUCKET.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public void aiStep() {
        if (this.isMoving() && this.isInWater() && this.wasEyeInWater) {
            Vec3 vec3d1 = this.getViewVector(0.0f);
            if (this.getCommandSenderWorld().getGameTime() % 2L == 0L) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() - vec3d1.x * 0.75, this.getY() + this.random.nextDouble() * (double)this.getBbHeight() - vec3d1.y * 1.0, this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() - vec3d1.z * 0.75, 0.0, 0.0, 0.0);
            }
        }
        super.aiStep();
    }

    public void travel(Vec3 p_213352_1_) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(0.01f, p_213352_1_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(p_213352_1_);
        }
    }

    public void onInsideBubbleColumn(boolean downwards) {
    }

    public void onAboveBubbleCol(boolean downwards) {
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.NAUTILUS_SPAWN_EGG.get());
    }

    public int getMaxSpawnClusterSize() {
        return 8;
    }

    static class MoveHelperController
    extends MoveControl {
        private final Nautilus nautilus;

        MoveHelperController(Nautilus nautilus) {
            super((Mob)nautilus);
            this.nautilus = nautilus;
        }

        public void tick() {
            if (this.nautilus.isEyeInFluid(FluidTags.WATER)) {
                this.nautilus.setDeltaMovement(this.nautilus.getDeltaMovement().add(0.0, 0.005, 0.0));
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.nautilus.getNavigation().isDone()) {
                double d0 = this.wantedX - this.nautilus.getX();
                double d1 = this.wantedY - this.nautilus.getY();
                double d2 = this.wantedZ - this.nautilus.getZ();
                double d3 = Mth.sqrt((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.nautilus.setYRot(this.rotlerp(this.nautilus.getYRot(), f, 90.0f));
                this.nautilus.yBodyRot = this.nautilus.getYRot();
                float f1 = (float)(this.speedModifier * this.nautilus.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                this.nautilus.setSpeed(Mth.lerp((float)0.125f, (float)this.nautilus.getSpeed(), (float)f1));
                this.nautilus.setDeltaMovement(this.nautilus.getDeltaMovement().add(0.0, (double)this.nautilus.getSpeed() * d1 * 0.03, 0.0));
                this.nautilus.setMoving(true);
            } else {
                this.nautilus.setSpeed(0.0f);
                this.nautilus.setMoving(false);
            }
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        public final Nautilus nautilus;

        public SwimGoal(Nautilus nautilus) {
            super((PathfinderMob)nautilus, 1.0, 30);
            this.nautilus = nautilus;
        }

        public boolean canUse() {
            return super.canUse();
        }
    }
}

