/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish;

import com.teamabnormals.blueprint.common.entity.BucketableWaterAnimal;
import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.upgrade_aquatic.common.block.JellyTorchBlock;
import com.teamabnormals.upgrade_aquatic.core.other.JellyfishRegistry;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.core.registry.UASoundEvents;
import com.teamabnormals.upgrade_aquatic.core.registry.datapack.UADamageTypes;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractJellyfish
extends BucketableWaterAnimal
implements Endimatable {
    protected static final EntityDataAccessor<Integer> COOLDOWN = SynchedEntityData.defineId(AbstractJellyfish.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Predicate<LivingEntity> CAN_STING = entity -> {
        if (entity instanceof Player && ((Player)entity).isCreative()) {
            return false;
        }
        return !entity.isSpectator() && !(entity instanceof AbstractJellyfish) && !(entity instanceof Turtle);
    };

    public AbstractJellyfish(EntityType<? extends AbstractJellyfish> type, Level world) {
        super(type, world);
        this.lookControl = new JellyfishLookControl((Mob)this);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 45, 10, 1.0f, 0.0f, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 1.25).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public static <J extends AbstractJellyfish> boolean checkJellyfishSpawnRules(EntityType<J> entity, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return pos.getY() > 45 && pos.getY() < world.getSeaLevel();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COOLDOWN, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readAdditionalSaveDataSharedWithBucket(compound);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addAdditionalSaveDataSharedWithBucket(compound);
    }

    protected void readAdditionalSaveDataSharedWithBucket(CompoundTag tag) {
        this.setCooldown(tag.getInt("CooldownTicks"));
    }

    protected void addAdditionalSaveDataSharedWithBucket(CompoundTag tag) {
        tag.putInt("CooldownTicks", this.getCooldown());
    }

    public void tick() {
        super.tick();
        if (this.isEffectiveAi()) {
            if (this.isPassenger()) {
                this.setYRot(0.0f);
                this.setXRot(0.0f);
                this.setAirSupply(this.getMaxAirSupply());
            } else if (this.isInWater() && this.getNavigation().isDone()) {
                float yaw = this.getYRot();
                float pitch = this.getXRot();
                float pitchFactor = Mth.cos((float)(pitch * ((float)Math.PI / 180)));
                float x = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * pitchFactor;
                float y = -Mth.sin((float)(pitch * ((float)Math.PI / 180)));
                float z = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * pitchFactor;
                Vec3 motion = new Vec3((double)x, (double)y, (double)z).normalize().scale(0.01666666753590107);
                this.push(motion.x, motion.y, motion.z);
            }
            if (!this.level().isClientSide && (Mth.abs((float)(this.xRotO - this.getXRot())) >= 1.0f || Mth.abs((float)(this.yRotO - this.getYRot())) >= 1.0f)) {
                this.hasImpulse = true;
            }
        }
        if (this.hasCooldown()) {
            if (this.isEffectiveAi()) {
                this.setCooldown(this.getCooldown() - 1);
                if (!this.hasCooldown()) {
                    this.playSound((SoundEvent)UASoundEvents.JELLYFISH_COOLDOWN_END.get(), 1.0f, this.random.nextFloat() * 0.15f + 1.0f);
                }
            }
            if (this.level().isClientSide && this.level().getGameTime() % 4L == 0L) {
                for (int i = 0; i < 2; ++i) {
                    this.level().addParticle((ParticleOptions)JellyTorchBlock.JellyTorchType.getBlobParticleType(this.getJellyTorchType()), this.getRandomX(0.5), this.getY() + (double)this.getEyeHeight(), this.getRandomZ(0.5), AbstractJellyfish.makeNegativeRandomly(this.random.nextDouble() * (double)0.05f, this.getRandom()), -this.random.nextDouble() * (double)0.05f, AbstractJellyfish.makeNegativeRandomly(this.random.nextDouble() * (double)0.05f, this.getRandom()));
                }
            }
        }
        if (this.isAlive()) {
            for (LivingEntity entities : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.15), CAN_STING)) {
                if (!entities.isAlive()) continue;
                this.stingEntity(entities);
            }
            if (this.isInWater() && this.isNoEndimationPlaying()) {
                this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, (double)0.005f, 0.0));
            }
        }
    }

    public static double makeNegativeRandomly(double value, RandomSource rand) {
        return rand.nextBoolean() ? -value : value;
    }

    public void travel(Vec3 Vector3d) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(0.01f, Vector3d);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.75));
        } else {
            super.travel(Vector3d);
        }
    }

    protected PathNavigation createNavigation(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        if (item == Items.WATER_BUCKET && this.isAlive()) {
            this.playSound((SoundEvent)UASoundEvents.BUCKET_FILL_JELLYFISH.get(), 1.0f, 1.0f);
            itemstack.shrink(1);
            ItemStack bucket = this.getBucketItemStack();
            this.saveToBucketTag(bucket);
            if (!this.level().isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, bucket);
            }
            if (itemstack.isEmpty()) {
                player.setItemInHand(hand, bucket);
            } else if (!player.getInventory().add(bucket)) {
                player.drop(bucket, false);
            }
            this.discard();
            return InteractionResult.SUCCESS;
        }
        if (itemstack.isEmpty() && this.getName().getString().toLowerCase(Locale.ROOT).trim().equals("jellysox345")) {
            this.startRiding((Entity)player);
            return InteractionResult.SUCCESS;
        }
        if (item == UAItems.PRISMARINE_ROD.get() && !this.hasCooldown()) {
            Random rand = new Random();
            if (this.isEffectiveAi() && rand.nextFloat() < this.getCooldownChance()) {
                this.setCooldown(20 * (rand.nextInt(16) + 15));
                this.playSound((SoundEvent)UASoundEvents.JELLYFISH_COOLDOWN_START.get(), 1.0f, this.random.nextFloat() * 0.15f + 1.0f);
            }
            itemstack.shrink(1);
            player.addItem(this.getTorchByType(this.getJellyTorchType()));
            this.playSound((SoundEvent)UASoundEvents.JELLYFISH_HARVEST.get(), 1.0f, this.random.nextFloat() * 0.15f + 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    protected SoundEvent getAmbientSound() {
        return this.isInWater() ? (SoundEvent)UASoundEvents.JELLYFISH_AMBIENT.get() : null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)UASoundEvents.JELLYFISH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UASoundEvents.JELLYFISH_DEATH.get();
    }

    public void playAmbientSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent != null) {
            this.playSound(soundevent, 0.25f, this.getVoicePitch());
        }
    }

    public int getAmbientSoundInterval() {
        return this.random.nextInt(200) + 200;
    }

    public void saveToBucketTag(ItemStack stack) {
        super.saveToBucketTag(stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> {
            tag.putString("EntityType", this.level().registryAccess().registryOrThrow(Registries.ENTITY_TYPE).getKey((Object)this.getType()).toString());
            tag.put("JellyfishDisplayTag", (Tag)this.getBucketDisplayInfo().write());
            this.addAdditionalSaveDataSharedWithBucket((CompoundTag)tag);
        });
    }

    public void loadFromBucketTag(CompoundTag compoundTag) {
        super.loadFromBucketTag(compoundTag);
        this.readAdditionalSaveDataSharedWithBucket(compoundTag);
    }

    public int getCooldown() {
        return (Integer)this.entityData.get(COOLDOWN);
    }

    public void setCooldown(int ticks) {
        this.entityData.set(COOLDOWN, (Object)ticks);
    }

    public boolean hasCooldown() {
        return this.getCooldown() > 0;
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)UAItems.JELLYFISH_BUCKET.get());
    }

    public SoundEvent getPickupSound() {
        return (SoundEvent)UASoundEvents.BUCKET_FILL_JELLYFISH.get();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.JELLYFISH_SPAWN_EGG.get());
    }

    public void calculateEntityAnimation(boolean p_233629_2_) {
        super.calculateEntityAnimation(true);
    }

    public abstract BucketDisplayInfo getBucketDisplayInfo();

    public abstract JellyTorchBlock.JellyTorchType getJellyTorchType();

    public abstract float getCooldownChance();

    protected final BucketDisplayInfo bucketDisplayInfo(String name, int subId, JellyTorchBlock.JellyTorchType ... yieldingTorchTypes) {
        return new BucketDisplayInfo(name, JellyfishRegistry.IDS.get(((Object)((Object)this)).getClass()), subId, yieldingTorchTypes);
    }

    protected boolean stingEntity(LivingEntity livingEntity) {
        if (livingEntity.hurt(UADamageTypes.jellyfishSting(this.level(), (Entity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue())) {
            this.playSound((SoundEvent)UASoundEvents.JELLYFISH_STING.get(), 0.5f, this.random.nextFloat() * 0.2f + 1.0f);
            return true;
        }
        return false;
    }

    protected ItemStack getTorchByType(JellyTorchBlock.JellyTorchType type) {
        return new ItemStack((ItemLike)type.torch.get());
    }

    public static class JellyfishLookControl
    extends LookControl {
        public JellyfishLookControl(Mob mob) {
            super(mob);
        }

        protected boolean resetXRotOnTick() {
            return false;
        }
    }

    public record BucketDisplayInfo(String name, int id, int subId, JellyTorchBlock.JellyTorchType[] yieldingTorchTypes) {
        public static float readVariant(CompoundTag compoundTag) {
            return (float)compoundTag.getInt("Id") + 0.1f * (float)compoundTag.getInt("SubId");
        }

        public static void appendHoverText(List<Component> tooltip, CompoundTag compoundTag) {
            String name = compoundTag.getString("Name");
            if (!name.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)("tooltip.upgrade_aquatic." + name + "_jellyfish")).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            if (!compoundTag.contains("YieldingTorchTypes", 11)) {
                return;
            }
            int[] yieldingTorchTypes = ((IntArrayTag)compoundTag.get("YieldingTorchTypes")).getAsIntArray();
            int length = yieldingTorchTypes.length;
            if (length <= 0) {
                return;
            }
            MutableComponent component = Component.translatable((String)"tooltip.upgrade_aquatic.yielding_jelly_torch").withStyle(ChatFormatting.GRAY);
            while (true) {
                JellyTorchBlock.JellyTorchType torchType = JellyTorchBlock.JellyTorchType.getByOrdinal(yieldingTorchTypes[length - 1]);
                component = component.append((Component)Component.translatable((String)("tooltip.upgrade_aquatic." + torchType.toString().toLowerCase(Locale.ROOT) + "_jelly_torch")).withStyle(torchType.color));
                if (--length <= 0) break;
                component = component.append((Component)Component.translatable((String)"tooltip.upgrade_aquatic.yielding_jelly_torch.or").withStyle(ChatFormatting.GRAY));
            }
            tooltip.add((Component)component);
        }

        public CompoundTag write() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("Name", this.name);
            compoundTag.putInt("Id", this.id);
            compoundTag.putInt("SubId", this.subId);
            IntArrayTag yieldingTorchTypesTag = new IntArrayTag(new int[0]);
            for (JellyTorchBlock.JellyTorchType jellyTorchType : this.yieldingTorchTypes) {
                yieldingTorchTypesTag.add((Object)IntTag.valueOf((int)jellyTorchType.ordinal()));
            }
            compoundTag.put("YieldingTorchTypes", (Tag)yieldingTorchTypesTag);
            return compoundTag;
        }
    }
}

