/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.projectile;

import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SonarWave
extends Entity {
    private static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.defineId(SonarWave.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private float growProgress = 0.0f;
    private float prevGrowProgress = 0.0f;

    public SonarWave(EntityType<? extends SonarWave> type, Level worldIn) {
        super(type, worldIn);
        this.blocksBuilding = true;
    }

    public SonarWave(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends SonarWave>)((EntityType)UAEntityTypes.SONAR_WAVE.get()), worldIn);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_ID, (Object)0);
    }

    public void tick() {
        super.tick();
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.getThrasherOwner() != null) {
            List entities = this.level().getEntities((Entity)this.getThrasherOwner(), this.getBoundingBox().inflate((double)this.growProgress), Thrasher.ENEMY_MATCHER);
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity) || this.getThrasherOwner().getTarget() != null) continue;
                this.getThrasherOwner().setTarget((LivingEntity)entity);
            }
        }
        Vec3 motion = this.getDeltaMovement();
        float horizontalMotionMagnitude = Mth.sqrt((float)((float)motion.horizontalDistanceSqr()));
        double motionX = motion.x();
        double motionY = motion.y();
        double motionZ = motion.z();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            this.setYRot((float)(Mth.atan2((double)motionX, (double)motionZ) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)motionY, (double)horizontalMotionMagnitude) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        this.setYRot((float)(Mth.atan2((double)motionX, (double)motionZ) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)motionY, (double)horizontalMotionMagnitude) * 57.2957763671875));
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.setXRot(Mth.lerp((float)0.2f, (float)this.xRotO, (float)this.getXRot()));
        this.setYRot(Mth.lerp((float)0.2f, (float)this.yRotO, (float)this.getYRot()));
        this.prevGrowProgress = this.growProgress;
        this.growProgress = this.growProgress < 0.1f ? (this.growProgress += 0.025f) : (this.growProgress += 0.1f);
        if (this.tickCount > 40) {
            this.discard();
        }
    }

    protected void moveTowardsClosestSpace(double x, double y, double z) {
    }

    public void fireSonarWave(Thrasher thrasher) {
        float xMotion = -Mth.sin((float)(thrasher.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(thrasher.getXRot() * ((float)Math.PI / 180)));
        float yMotion = -Mth.sin((float)(thrasher.getXRot() * ((float)Math.PI / 180)));
        float zMotion = Mth.cos((float)(thrasher.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(thrasher.getXRot() * ((float)Math.PI / 180)));
        Vec3 motion = new Vec3((double)xMotion, (double)yMotion, (double)zMotion).normalize().scale(0.75);
        this.setDeltaMovement(motion);
        this.setOwnerId(thrasher.getId());
        this.setPos(thrasher.getX() + (double)xMotion, thrasher.getY(), thrasher.getZ() + (double)zMotion);
        float motionSqrt = Mth.sqrt((float)((float)motion.horizontalDistanceSqr()));
        this.setYRot((float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.29577951308232));
        this.setYRot((float)(Mth.atan2((double)motion.y, (double)motionSqrt) * 57.29577951308232));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public void onInsideBubbleColumn(boolean downwards) {
    }

    public void onAboveBubbleCol(boolean downwards) {
    }

    protected void doWaterSplashEffect() {
    }

    public boolean isPushedByFluid() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGrowProgress() {
        return Mth.lerp((float)ClientInfo.getPartialTicks(), (float)this.prevGrowProgress, (float)this.growProgress);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setOwnerId(compound.getInt("OwnerId"));
        this.growProgress = compound.getFloat("GrowProgress");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("OwnerId", this.getOwnerId());
        compound.putFloat("GrowProgress", this.growProgress);
    }

    public void setOwnerId(int id) {
        this.getEntityData().set(OWNER_ID, (Object)id);
    }

    public int getOwnerId() {
        return (Integer)this.getEntityData().get(OWNER_ID);
    }

    @Nullable
    public Thrasher getThrasherOwner() {
        Entity owner = this.level().getEntity(this.getOwnerId());
        if (owner instanceof Thrasher) {
            return (Thrasher)owner;
        }
        return null;
    }
}

