/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.data.server;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.upgrade_aquatic.common.block.BedrollBlock;
import com.teamabnormals.upgrade_aquatic.common.block.MulberryVineBlock;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;

public class UALootTableProvider
extends LootTableProvider {
    public UALootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, BuiltInLootTables.all(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(UABlockLoot::new, LootContextParamSets.BLOCK), (Object)new LootTableProvider.SubProviderEntry(UAEntityLoot::new, LootContextParamSets.ENTITY)), provider);
    }

    protected void validate(WritableRegistry<LootTable> registry, ValidationContext context, ProblemReporter.Collector collector) {
    }

    private static class UAEntityLoot
    extends EntityLootSubProvider {
        protected UAEntityLoot(HolderLookup.Provider provider) {
            super(FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            this.add((EntityType)UAEntityTypes.FLARE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PHANTOM_MEMBRANE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).when(LootItemKilledByPlayerCondition.killedByPlayer())));
            this.add((EntityType)UAEntityTypes.PERCH.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.PERCH.get())).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE_MEAL)).when(LootItemRandomChanceCondition.randomChance((float)0.05f))));
            this.add((EntityType)UAEntityTypes.PIKE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.PIKE.get())).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE_MEAL)).when(LootItemRandomChanceCondition.randomChance((float)0.2f))));
            this.add((EntityType)UAEntityTypes.LIONFISH.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.LIONFISH.get())).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE_MEAL)).when(LootItemRandomChanceCondition.randomChance((float)0.05f))));
            this.add((EntityType)UAEntityTypes.THRASHER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.THRASHER_TOOTH.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.THRASHER_TOOTH.get()))).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.2f, (float)0.2f))));
            this.add((EntityType)UAEntityTypes.GREAT_THRASHER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.THRASHER_TOOTH.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UAItems.THRASHER_TOOTH.get()))).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.2f, (float)0.2f))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(UAItems.DISC_FRAGMENT_ATLANTIS)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(LootItemRandomChanceCondition.randomChance((float)0.33f))));
            this.add((EntityType)UAEntityTypes.NAUTILUS.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NAUTILUS_SHELL)).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.5f, (float)0.15f))));
            this.add((EntityType)UAEntityTypes.GOOSE.get(), LootTable.lootTable());
            this.add((EntityType)UAEntityTypes.BOX_JELLYFISH.get(), LootTable.lootTable());
            this.add((EntityType)UAEntityTypes.CASSIOPEA_JELLYFISH.get(), LootTable.lootTable());
            this.add((EntityType)UAEntityTypes.IMMORTAL_JELLYFISH.get(), LootTable.lootTable());
        }

        public Stream<EntityType<?>> getKnownEntityTypes() {
            return BuiltInRegistries.ENTITY_TYPE.stream().filter(entity -> BuiltInRegistries.ENTITY_TYPE.getKey(entity).getNamespace().equals("upgrade_aquatic"));
        }
    }

    private static class UABlockLoot
    extends BlockLootSubProvider {
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(Blocks.DRAGON_EGG, Blocks.BEACON, Blocks.CONDUIT, Blocks.SKELETON_SKULL, Blocks.WITHER_SKELETON_SKULL, Blocks.PLAYER_HEAD, Blocks.ZOMBIE_HEAD, Blocks.CREEPER_HEAD, Blocks.DRAGON_HEAD, Blocks.PIGLIN_HEAD, Blocks.SHULKER_BOX, Blocks.BLACK_SHULKER_BOX, Blocks.BLUE_SHULKER_BOX, Blocks.BROWN_SHULKER_BOX, Blocks.CYAN_SHULKER_BOX, Blocks.GRAY_SHULKER_BOX, Blocks.GREEN_SHULKER_BOX, Blocks.LIGHT_BLUE_SHULKER_BOX, Blocks.LIGHT_GRAY_SHULKER_BOX, Blocks.LIME_SHULKER_BOX, Blocks.MAGENTA_SHULKER_BOX, Blocks.ORANGE_SHULKER_BOX, Blocks.PINK_SHULKER_BOX, Blocks.PURPLE_SHULKER_BOX, Blocks.RED_SHULKER_BOX, Blocks.WHITE_SHULKER_BOX, Blocks.YELLOW_SHULKER_BOX).map(ItemLike::asItem).collect(Collectors.toSet());
        private static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR));
        private static final float[] RIVER_LEAVES_SAPLING_CHANCES = new float[]{0.15f, 0.1875f, 0.25f, 0.3f};

        protected LootItemCondition.Builder doesNotHaveSilkTouch() {
            return this.hasSilkTouch().invert();
        }

        private LootItemCondition.Builder hasShearsOrSilkTouch() {
            return HAS_SHEARS.or(this.hasSilkTouch());
        }

        private LootItemCondition.Builder doesNotHaveShearsOrSilkTouch() {
            return this.hasShearsOrSilkTouch().invert();
        }

        protected UABlockLoot(HolderLookup.Provider provider) {
            super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            this.add((Block)UABlocks.BUBBLE_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.BUBBLE_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.BUBBLE_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.BUBBLE_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.BUBBLE_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.HORN_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.HORN_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.HORN_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.HORN_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.HORN_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.TUBE_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.TUBE_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.TUBE_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.TUBE_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.TUBE_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.BRAIN_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.BRAIN_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.BRAIN_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.BRAIN_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.BRAIN_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.FIRE_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.FIRE_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.FIRE_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.FIRE_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.FIRE_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.ACAN_CORAL_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_ACAN_CORAL_BLOCK));
            this.dropWhenSilkTouch((Block)UABlocks.ACAN_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.ACAN_CORAL_FAN.get());
            this.dropSelf((Block)UABlocks.DEAD_ACAN_CORAL_BLOCK.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_ACAN_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_ACAN_CORAL_FAN.get());
            this.add((Block)UABlocks.ACAN_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.ACAN_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.ACAN_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.ACAN_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.ACAN_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.FINGER_CORAL_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_FINGER_CORAL_BLOCK));
            this.dropWhenSilkTouch((Block)UABlocks.FINGER_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.FINGER_CORAL_FAN.get());
            this.dropSelf((Block)UABlocks.DEAD_FINGER_CORAL_BLOCK.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_FINGER_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_FINGER_CORAL_FAN.get());
            this.add((Block)UABlocks.FINGER_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.FINGER_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.FINGER_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.FINGER_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.FINGER_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.STAR_CORAL_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_STAR_CORAL_BLOCK));
            this.dropWhenSilkTouch((Block)UABlocks.STAR_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.STAR_CORAL_FAN.get());
            this.dropSelf((Block)UABlocks.DEAD_STAR_CORAL_BLOCK.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_STAR_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_STAR_CORAL_FAN.get());
            this.add((Block)UABlocks.STAR_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.STAR_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.STAR_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.STAR_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.STAR_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.MOSS_CORAL_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_MOSS_CORAL_BLOCK));
            this.dropWhenSilkTouch((Block)UABlocks.MOSS_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.MOSS_CORAL_FAN.get());
            this.dropSelf((Block)UABlocks.DEAD_MOSS_CORAL_BLOCK.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_MOSS_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_MOSS_CORAL_FAN.get());
            this.add((Block)UABlocks.MOSS_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.MOSS_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.MOSS_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.MOSS_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.MOSS_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.PETAL_CORAL_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_PETAL_CORAL_BLOCK));
            this.dropWhenSilkTouch((Block)UABlocks.PETAL_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.PETAL_CORAL_FAN.get());
            this.dropSelf((Block)UABlocks.DEAD_PETAL_CORAL_BLOCK.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_PETAL_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_PETAL_CORAL_FAN.get());
            this.add((Block)UABlocks.PETAL_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.PETAL_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.PETAL_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.PETAL_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.PETAL_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.BRANCH_CORAL_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_BRANCH_CORAL_BLOCK));
            this.dropWhenSilkTouch((Block)UABlocks.BRANCH_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.BRANCH_CORAL_FAN.get());
            this.dropSelf((Block)UABlocks.DEAD_BRANCH_CORAL_BLOCK.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_BRANCH_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_BRANCH_CORAL_FAN.get());
            this.add((Block)UABlocks.BRANCH_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.BRANCH_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.BRANCH_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.BRANCH_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.BRANCH_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.ROCK_CORAL_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_ROCK_CORAL_BLOCK));
            this.dropWhenSilkTouch((Block)UABlocks.ROCK_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.ROCK_CORAL_FAN.get());
            this.dropSelf((Block)UABlocks.DEAD_ROCK_CORAL_BLOCK.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_ROCK_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_ROCK_CORAL_FAN.get());
            this.add((Block)UABlocks.ROCK_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.ROCK_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.ROCK_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.ROCK_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.ROCK_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.PILLOW_CORAL_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_PILLOW_CORAL_BLOCK));
            this.dropWhenSilkTouch((Block)UABlocks.PILLOW_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.PILLOW_CORAL_FAN.get());
            this.dropSelf((Block)UABlocks.DEAD_PILLOW_CORAL_BLOCK.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_PILLOW_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_PILLOW_CORAL_FAN.get());
            this.add((Block)UABlocks.PILLOW_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.PILLOW_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.PILLOW_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.PILLOW_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.PILLOW_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.SILK_CORAL_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_SILK_CORAL_BLOCK));
            this.dropWhenSilkTouch((Block)UABlocks.SILK_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.SILK_CORAL_FAN.get());
            this.dropSelf((Block)UABlocks.DEAD_SILK_CORAL_BLOCK.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_SILK_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_SILK_CORAL_FAN.get());
            this.add((Block)UABlocks.SILK_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.SILK_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.SILK_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.SILK_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.SILK_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.add((Block)UABlocks.CHROME_CORAL_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHROME_CORAL_BLOCK));
            this.dropWhenSilkTouch((Block)UABlocks.CHROME_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.CHROME_CORAL_FAN.get());
            this.dropSelf((Block)UABlocks.DEAD_CHROME_CORAL_BLOCK.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_CHROME_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.DEAD_CHROME_CORAL_FAN.get());
            this.add((Block)UABlocks.CHROME_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE));
            this.add((Block)UABlocks.CHROME_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.CHROME_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.DEAD_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.CHROME_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL));
            this.add((Block)UABlocks.CHROME_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.DEAD_CHISELED_CORALSTONE));
            this.dropSelf((Block)UABlocks.ELDER_PRISMARINE_CORAL_BLOCK.get());
            this.dropWhenSilkTouch((Block)UABlocks.ELDER_PRISMARINE_CORAL.get());
            this.dropWhenSilkTouch((Block)UABlocks.ELDER_PRISMARINE_CORAL_FAN.get());
            this.dropWhenSilkTouch((Block)UABlocks.ELDER_PRISMARINE_CORAL_SHOWER.get());
            this.add((Block)UABlocks.PRISMARINE_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.ELDER_PRISMARINE_CORALSTONE));
            this.add((Block)UABlocks.PRISMARINE_CORALSTONE_STAIRS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.ELDER_PRISMARINE_CORALSTONE_STAIRS));
            this.add((Block)UABlocks.PRISMARINE_CORALSTONE_SLAB.get(), block -> this.createCoralstoneSlabTable((Block)block, (Block)UABlocks.ELDER_PRISMARINE_CORALSTONE_SLAB.get()));
            this.add((Block)UABlocks.PRISMARINE_CORALSTONE_WALL.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.ELDER_PRISMARINE_CORALSTONE_WALL));
            this.add((Block)UABlocks.PRISMARINE_CHISELED_CORALSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)UABlocks.CHISELED_ELDER_PRISMARINE_CORALSTONE));
            this.dropSelf((Block)UABlocks.CORALSTONE.get());
            this.dropSelf((Block)UABlocks.CORALSTONE_STAIRS.get());
            this.add((Block)UABlocks.CORALSTONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.CORALSTONE_WALL.get());
            this.dropSelf((Block)UABlocks.CHISELED_CORALSTONE.get());
            this.dropSelf((Block)UABlocks.DEAD_CORALSTONE.get());
            this.dropSelf((Block)UABlocks.DEAD_CORALSTONE_STAIRS.get());
            this.add((Block)UABlocks.DEAD_CORALSTONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.DEAD_CORALSTONE_WALL.get());
            this.dropSelf((Block)UABlocks.DEAD_CHISELED_CORALSTONE.get());
            this.dropSelf((Block)UABlocks.ELDER_PRISMARINE_CORALSTONE.get());
            this.dropSelf((Block)UABlocks.ELDER_PRISMARINE_CORALSTONE_STAIRS.get());
            this.add((Block)UABlocks.ELDER_PRISMARINE_CORALSTONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.ELDER_PRISMARINE_CORALSTONE_WALL.get());
            this.dropSelf((Block)UABlocks.CHISELED_ELDER_PRISMARINE_CORALSTONE.get());
            this.dropSelf((Block)UABlocks.BEACHGRASS_THATCH.get());
            this.dropSelf((Block)UABlocks.BEACHGRASS_THATCH_STAIRS.get());
            this.add((Block)UABlocks.BEACHGRASS_THATCH_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.ELDER_EYE.get());
            this.dropSelf((Block)UABlocks.EMBEDDED_AMMONITE.get());
            this.dropSelf((Block)UABlocks.LUMINOUS_PRISMARINE.get());
            this.dropSelf((Block)UABlocks.LUMINOUS_PRISMARINE_STAIRS.get());
            this.add((Block)UABlocks.LUMINOUS_PRISMARINE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.PRISMARINE_ROD_BUNDLE.get());
            this.dropSelf((Block)UABlocks.MULBERRY_JAM_BLOCK.get());
            this.dropSelf((Block)UABlocks.MULBERRY_PUNNET.get());
            this.dropSelf((Block)UABlocks.TOOTH_BLOCK.get());
            this.dropSelf((Block)UABlocks.TOOTH_BRICKS.get());
            this.dropSelf((Block)UABlocks.TOOTH_BRICK_STAIRS.get());
            this.dropSelf((Block)UABlocks.TOOTH_BRICK_WALL.get());
            this.add((Block)UABlocks.TOOTH_BRICK_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.CHISELED_TOOTH_BRICKS.get());
            this.dropSelf((Block)UABlocks.TOOTH_TILES.get());
            this.dropSelf((Block)UABlocks.TOOTH_TILE_STAIRS.get());
            this.dropSelf((Block)UABlocks.TOOTH_TILE_WALL.get());
            this.add((Block)UABlocks.TOOTH_TILE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)UABlocks.TOOTH_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.dropSelf((Block)UABlocks.TOOTH_TRAPDOOR.get());
            this.dropSelf((Block)UABlocks.TOOTH_LANTERN.get());
            this.dropSelf((Block)UABlocks.SCUTE_BLOCK.get());
            this.dropSelf((Block)UABlocks.SCUTE_SHINGLES.get());
            this.dropSelf((Block)UABlocks.SCUTE_SHINGLE_STAIRS.get());
            this.dropSelf((Block)UABlocks.SCUTE_SHINGLE_WALL.get());
            this.add((Block)UABlocks.SCUTE_SHINGLE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.CHISELED_SCUTE_SHINGLES.get());
            this.dropSelf((Block)UABlocks.SCUTE_PAVEMENT.get());
            this.dropSelf((Block)UABlocks.SCUTE_PAVEMENT_STAIRS.get());
            this.dropSelf((Block)UABlocks.SCUTE_PAVEMENT_WALL.get());
            this.add((Block)UABlocks.SCUTE_PAVEMENT_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.PICKERELWEED.get());
            this.dropOther((Block)UABlocks.TALL_PICKERELWEED.get(), (ItemLike)UABlocks.PICKERELWEED.get());
            this.dropSelf((Block)UABlocks.PICKERELWEED_BLOCK.get());
            this.dropSelf((Block)UABlocks.BOILED_PICKERELWEED_BLOCK.get());
            this.dropPottedContents((Block)UABlocks.POTTED_PICKERELWEED.get());
            this.dropSelf((Block)UABlocks.KELP_BLOCK.get());
            this.dropSelf((Block)UABlocks.KELPY_COBBLESTONE.get());
            this.dropSelf((Block)UABlocks.KELPY_COBBLESTONE_STAIRS.get());
            this.dropSelf((Block)UABlocks.KELPY_COBBLESTONE_WALL.get());
            this.add((Block)UABlocks.KELPY_COBBLESTONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.KELPY_COBBLESTONE_BRICKS.get());
            this.dropSelf((Block)UABlocks.KELPY_COBBLESTONE_BRICK_STAIRS.get());
            this.dropSelf((Block)UABlocks.KELPY_COBBLESTONE_BRICK_WALL.get());
            this.add((Block)UABlocks.KELPY_COBBLESTONE_BRICK_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.KELPY_COBBLESTONE_TILES.get());
            this.dropSelf((Block)UABlocks.KELPY_COBBLESTONE_TILE_STAIRS.get());
            this.dropSelf((Block)UABlocks.KELPY_COBBLESTONE_TILE_WALL.get());
            this.add((Block)UABlocks.KELPY_COBBLESTONE_TILE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.KELPY_STONE_BRICKS.get());
            this.dropSelf((Block)UABlocks.KELPY_STONE_BRICK_STAIRS.get());
            this.dropSelf((Block)UABlocks.KELPY_STONE_BRICK_WALL.get());
            this.add((Block)UABlocks.KELPY_STONE_BRICK_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)UABlocks.RIVER_PLANKS.get());
            this.dropSelf((Block)UABlocks.RIVER_LOG.get());
            this.dropSelf((Block)UABlocks.RIVER_WOOD.get());
            this.dropSelf((Block)UABlocks.STRIPPED_RIVER_LOG.get());
            this.dropSelf((Block)UABlocks.STRIPPED_RIVER_WOOD.get());
            this.dropSelf((Block)((DeferredBlock)UABlocks.RIVER_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)UABlocks.RIVER_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)UABlocks.RIVER_PRESSURE_PLATE.get());
            this.dropSelf((Block)UABlocks.RIVER_TRAPDOOR.get());
            this.dropSelf((Block)UABlocks.RIVER_BUTTON.get());
            this.dropSelf((Block)UABlocks.RIVER_STAIRS.get());
            this.dropSelf((Block)UABlocks.RIVER_FENCE.get());
            this.dropSelf((Block)UABlocks.RIVER_FENCE_GATE.get());
            this.dropSelf((Block)UABlocks.RIVER_BOARDS.get());
            this.add((Block)UABlocks.RIVER_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)UABlocks.RIVER_SAPLING.get());
            this.dropPottedContents((Block)UABlocks.POTTED_RIVER_SAPLING.get());
            this.dropSelf((Block)UABlocks.RIVER_LADDER.get());
            this.add((Block)UABlocks.RIVER_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)UABlocks.RIVER_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)UABlocks.RIVER_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)UABlocks.RIVER_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)UABlocks.TRAPPED_RIVER_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)UABlocks.RIVER_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)UABlocks.CHISELED_RIVER_BOOKSHELF.get());
            this.add((Block)UABlocks.RIVER_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)UABlocks.RIVER_SAPLING.get(), RIVER_LEAVES_SAPLING_CHANCES));
            this.dropSelf((Block)UABlocks.DRIFTWOOD_PLANKS.get());
            this.dropSelf((Block)UABlocks.DRIFTWOOD_LOG.get());
            this.dropSelf((Block)UABlocks.DRIFTWOOD.get());
            this.dropSelf((Block)UABlocks.STRIPPED_DRIFTWOOD_LOG.get());
            this.dropSelf((Block)UABlocks.STRIPPED_DRIFTWOOD.get());
            this.dropSelf((Block)((DeferredBlock)UABlocks.DRIFTWOOD_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)UABlocks.DRIFTWOOD_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)UABlocks.DRIFTWOOD_PRESSURE_PLATE.get());
            this.dropSelf((Block)UABlocks.DRIFTWOOD_TRAPDOOR.get());
            this.dropSelf((Block)UABlocks.DRIFTWOOD_BUTTON.get());
            this.dropSelf((Block)UABlocks.DRIFTWOOD_STAIRS.get());
            this.dropSelf((Block)UABlocks.DRIFTWOOD_FENCE.get());
            this.dropSelf((Block)UABlocks.DRIFTWOOD_FENCE_GATE.get());
            this.dropSelf((Block)UABlocks.DRIFTWOOD_BOARDS.get());
            this.dropSelf((Block)UABlocks.DRIFTWOOD_LADDER.get());
            this.add((Block)UABlocks.DRIFTWOOD_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)UABlocks.DRIFTWOOD_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)UABlocks.DRIFTWOOD_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)UABlocks.DRIFTWOOD_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)UABlocks.TRAPPED_DRIFTWOOD_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)UABlocks.DRIFTWOOD_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)UABlocks.CHISELED_DRIFTWOOD_BOOKSHELF.get());
            this.dropSelf((Block)UABlocks.PINK_JELLY_TORCH.get());
            this.dropSelf((Block)UABlocks.PURPLE_JELLY_TORCH.get());
            this.dropSelf((Block)UABlocks.BLUE_JELLY_TORCH.get());
            this.dropSelf((Block)UABlocks.GREEN_JELLY_TORCH.get());
            this.dropSelf((Block)UABlocks.YELLOW_JELLY_TORCH.get());
            this.dropSelf((Block)UABlocks.ORANGE_JELLY_TORCH.get());
            this.dropSelf((Block)UABlocks.RED_JELLY_TORCH.get());
            this.dropSelf((Block)UABlocks.WHITE_JELLY_TORCH.get());
            this.dropSelf((Block)UABlocks.WHITE_SEAROCKET.get());
            this.dropPottedContents((Block)UABlocks.POTTED_WHITE_SEAROCKET.get());
            this.dropSelf((Block)UABlocks.PINK_SEAROCKET.get());
            this.dropPottedContents((Block)UABlocks.POTTED_PINK_SEAROCKET.get());
            this.add((Block)UABlocks.FLOWERING_RUSH.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.add((Block)UABlocks.BEACHGRASS.get(), this::createBeachgrassDrops);
            this.add((Block)UABlocks.TALL_BEACHGRASS.get(), block -> this.createTallBeachGrassDrops((Block)block, (Block)UABlocks.TALL_BEACHGRASS.get()));
            this.add((Block)UABlocks.BEDROLL.get(), this::createBedrollTable);
            this.add((Block)UABlocks.MULBERRY_VINE.get(), this::createMulberryVineTable);
            HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            this.add((Block)UABlocks.PRISMARINE_CORAL_BLOCK.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.PRISMARINE_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.range((int)1, (int)4))))));
            this.add((Block)UABlocks.PRISMARINE_CORAL.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.PRISMARINE_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.range((int)1, (int)4))))));
            this.add((Block)UABlocks.PRISMARINE_CORAL_FAN.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.PRISMARINE_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.range((int)1, (int)4))))));
            this.add((Block)UABlocks.PRISMARINE_CORAL_SHOWER.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.PRISMARINE_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.range((int)1, (int)4))))));
        }

        protected LootTable.Builder createBedrollTable(Block block) {
            return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.DYED_COLOR)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BedrollBlock.PART, (Comparable)BedPart.HEAD))))));
        }

        protected LootTable.Builder createLeafPileDrops(Block block) {
            return this.createMultifaceBlockDrops(block, MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR)));
        }

        protected LootTable.Builder createBeachgrassDrops(Block block) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return this.createShearsDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BEETROOT_SEEDS).when(LootItemRandomChanceCondition.randomChance((float)0.125f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (int)2))));
        }

        protected LootTable.Builder createTallBeachGrassDrops(Block block, Block sheared) {
            AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)sheared).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))).when(HAS_SHEARS)).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.BEETROOT_SEEDS))).when(LootItemRandomChanceCondition.randomChance((float)0.125f)));
            return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
        }

        protected LootTable.Builder createCoralstoneSlabTable(Block block, Block deadBlock) {
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE)))))).when(this.hasSilkTouch())).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)deadBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)deadBlock).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)deadBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE))))))));
        }

        protected LootTable.Builder createMulberryVineTable(Block block) {
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MulberryVineBlock.DOUBLE, true)))))));
        }

        public Iterable<Block> getKnownBlocks() {
            return BuiltInRegistries.BLOCK.stream().filter(block -> BuiltInRegistries.BLOCK.getKey(block).getNamespace().equals("upgrade_aquatic")).collect(Collectors.toSet());
        }
    }
}

