/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.data.server.tags;

import com.teamabnormals.blueprint.core.other.tags.BlueprintBlockTags;
import com.teamabnormals.upgrade_aquatic.common.block.CoralType;
import com.teamabnormals.upgrade_aquatic.core.other.tags.UABlockTags;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class UABlockTagsProvider
extends BlockTagsProvider {
    private Collection<DeferredHolder<Block, ? extends Block>> entries = ((DeferredRegister.Blocks)UABlocks.BLOCKS.getDeferredRegister()).getEntries();

    public UABlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        super(output, provider, "upgrade_aquatic", helper);
    }

    public void addTags(HolderLookup.Provider provider) {
        this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)((Block)UABlocks.MULBERRY_PUNNET.get()));
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{(Block)UABlocks.EMBEDDED_AMMONITE.get(), (Block)UABlocks.PRISMARINE_ROD_BUNDLE.get(), (Block)UABlocks.ELDER_EYE.get()});
        this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object)((Block)UABlocks.RIVER_LEAVES.get()));
        for (DeferredHolder holder : ((DeferredRegister.Blocks)UABlocks.BLOCKS.getDeferredRegister()).getEntries()) {
            Block block = (Block)holder.get();
            String path = holder.getId().getPath();
            if (path.contains("luminous_prismarine") || path.contains("dead") && path.contains("coral") || path.contains("coral_block") || path.contains("tooth") || path.contains("scute") || path.contains("coralstone") || path.contains("kelpy_cobblestone") || path.contains("kelpy_stone")) {
                this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)block);
                continue;
            }
            if (!path.contains("beachgrass") && !path.contains("pickerelweed_block") && !path.contains("kelp_block")) continue;
            this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object)block);
        }
        this.tag((TagKey<Block>)BlockTags.STAIRS, UABlockTagsProvider.is(StairBlock.class), (TagKey<Block>)BlockTags.WOODEN_STAIRS, (Block)UABlocks.DRIFTWOOD_STAIRS.get(), (Block)UABlocks.RIVER_STAIRS.get());
        this.tag((TagKey<Block>)BlockTags.SLABS, UABlockTagsProvider.is(SlabBlock.class), (TagKey<Block>)BlockTags.WOODEN_SLABS, (Block)UABlocks.DRIFTWOOD_SLAB.get(), (Block)UABlocks.RIVER_SLAB.get());
        this.tag((TagKey<Block>)BlockTags.WALLS, UABlockTagsProvider.is(WallBlock.class));
        this.tag((TagKey<Block>)BlockTags.DOORS, UABlockTagsProvider.is(DoorBlock.class), (TagKey<Block>)BlockTags.WOODEN_DOORS, (Block)UABlocks.DRIFTWOOD_DOOR.get(), (Block)UABlocks.RIVER_DOOR.get());
        this.tag((TagKey<Block>)BlockTags.TRAPDOORS, UABlockTagsProvider.is(TrapDoorBlock.class), (TagKey<Block>)BlockTags.WOODEN_TRAPDOORS, (Block)UABlocks.DRIFTWOOD_TRAPDOOR.get(), (Block)UABlocks.RIVER_TRAPDOOR.get());
        this.tag((TagKey<Block>)BlockTags.SMALL_FLOWERS, UABlockTagsProvider.is(FlowerBlock.class));
        this.tag((TagKey<Block>)BlockTags.TALL_FLOWERS, UABlockTagsProvider.is(TallFlowerBlock.class));
        this.tag((TagKey<Block>)BlockTags.FLOWER_POTS, UABlockTagsProvider.is(FlowerPotBlock.class));
        this.tag(BlockTags.PLANKS).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_PLANKS.get(), (Block)UABlocks.RIVER_PLANKS.get()});
        this.tag(BlockTags.LOGS_THAT_BURN).addTag(UABlockTags.DRIFTWOOD_LOGS).addTag(UABlockTags.RIVER_LOGS);
        this.tag(BlockTags.WOODEN_FENCES).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_FENCE.get(), (Block)UABlocks.RIVER_FENCE.get()});
        this.tag(BlockTags.FENCE_GATES).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_FENCE_GATE.get(), (Block)UABlocks.RIVER_FENCE_GATE.get()});
        this.tag(Tags.Blocks.FENCE_GATES_WOODEN).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_FENCE_GATE.get(), (Block)UABlocks.RIVER_FENCE_GATE.get()});
        this.tag(BlockTags.WOODEN_BUTTONS).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_BUTTON.get(), (Block)UABlocks.RIVER_BUTTON.get()});
        this.tag(BlockTags.WOODEN_PRESSURE_PLATES).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_PRESSURE_PLATE.get(), (Block)UABlocks.RIVER_PRESSURE_PLATE.get()});
        this.tag(BlockTags.STANDING_SIGNS).add((Object[])new Block[]{(Block)((DeferredBlock)UABlocks.DRIFTWOOD_SIGNS.getFirst()).get(), (Block)((DeferredBlock)UABlocks.RIVER_SIGNS.getFirst()).get()});
        this.tag(BlockTags.WALL_SIGNS).add((Object[])new Block[]{(Block)((DeferredBlock)UABlocks.DRIFTWOOD_SIGNS.getSecond()).get(), (Block)((DeferredBlock)UABlocks.RIVER_SIGNS.getSecond()).get()});
        this.tag(BlockTags.CEILING_HANGING_SIGNS).add((Object[])new Block[]{(Block)((DeferredBlock)UABlocks.DRIFTWOOD_HANGING_SIGNS.getFirst()).get(), (Block)((DeferredBlock)UABlocks.RIVER_HANGING_SIGNS.getFirst()).get()});
        this.tag(BlockTags.WALL_HANGING_SIGNS).add((Object[])new Block[]{(Block)((DeferredBlock)UABlocks.DRIFTWOOD_HANGING_SIGNS.getSecond()).get(), (Block)((DeferredBlock)UABlocks.RIVER_HANGING_SIGNS.getSecond()).get()});
        this.tag(BlockTags.OVERWORLD_NATURAL_LOGS).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_LOG.get(), (Block)UABlocks.RIVER_LOG.get()});
        this.tag(BlockTags.LEAVES).add((Object)((Block)UABlocks.RIVER_LEAVES.get()));
        this.tag(BlockTags.SAPLINGS).add((Object)((Block)UABlocks.RIVER_SAPLING.get()));
        this.tag(Tags.Blocks.STRIPPED_LOGS).add((Object[])new Block[]{(Block)UABlocks.STRIPPED_DRIFTWOOD_LOG.get(), (Block)UABlocks.STRIPPED_RIVER_LOG.get()});
        this.tag(Tags.Blocks.STRIPPED_WOODS).add((Object[])new Block[]{(Block)UABlocks.STRIPPED_DRIFTWOOD.get(), (Block)UABlocks.STRIPPED_RIVER_WOOD.get()});
        this.tag(BlockTags.REPLACEABLE).add((Object[])new Block[]{(Block)UABlocks.BEACHGRASS.get(), (Block)UABlocks.TALL_BEACHGRASS.get()});
        this.tag(UABlockTags.DRIFTWOOD_LOGS).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_LOG.get(), (Block)UABlocks.DRIFTWOOD.get(), (Block)UABlocks.STRIPPED_DRIFTWOOD_LOG.get(), (Block)UABlocks.STRIPPED_DRIFTWOOD.get()});
        this.tag(UABlockTags.RIVER_LOGS).add((Object[])new Block[]{(Block)UABlocks.RIVER_LOG.get(), (Block)UABlocks.RIVER_WOOD.get(), (Block)UABlocks.STRIPPED_RIVER_LOG.get(), (Block)UABlocks.STRIPPED_RIVER_WOOD.get()});
        this.tag(UABlockTags.PIKE_SPAWNABLE_IN).add((Object[])new Block[]{(Block)UABlocks.PICKERELWEED.get(), (Block)UABlocks.TALL_PICKERELWEED.get()});
        this.tag(UABlockTags.PICKERELWEED_PLACEABLE).addTag(BlockTags.DIRT).add((Object[])new Block[]{Blocks.CLAY, Blocks.FARMLAND});
        this.tag(BlueprintBlockTags.WOODEN_BOARDS).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_BOARDS.get(), (Block)UABlocks.RIVER_BOARDS.get()});
        this.tag(BlueprintBlockTags.WOODEN_CHESTS).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_CHEST.get(), (Block)UABlocks.RIVER_CHEST.get()});
        this.tag(BlueprintBlockTags.WOODEN_TRAPPED_CHESTS).add((Object[])new Block[]{(Block)UABlocks.TRAPPED_DRIFTWOOD_CHEST.get(), (Block)UABlocks.TRAPPED_RIVER_CHEST.get()});
        this.tag(BlueprintBlockTags.WOODEN_BEEHIVES).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_BEEHIVE.get(), (Block)UABlocks.RIVER_BEEHIVE.get()});
        this.tag(BlueprintBlockTags.WOODEN_LADDERS).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_LADDER.get(), (Block)UABlocks.RIVER_LADDER.get()});
        this.tag(BlueprintBlockTags.WOODEN_BOOKSHELVES).add((Object[])new Block[]{(Block)UABlocks.DRIFTWOOD_BOOKSHELF.get(), (Block)UABlocks.RIVER_BOOKSHELF.get()});
        this.tag(BlueprintBlockTags.WOODEN_CHISELED_BOOKSHELVES).add((Object[])new Block[]{(Block)UABlocks.CHISELED_DRIFTWOOD_BOOKSHELF.get(), (Block)UABlocks.CHISELED_RIVER_BOOKSHELF.get()});
        this.tag(BlueprintBlockTags.LEAF_PILES).add((Object)((Block)UABlocks.RIVER_LEAF_PILE.get()));
        this.tag(Tags.Blocks.COBBLESTONES_MOSSY).add((Object)((Block)UABlocks.KELPY_COBBLESTONE.get()));
        this.tag(Tags.Blocks.STORAGE_BLOCKS).add((Object[])new Block[]{(Block)UABlocks.PRISMARINE_ROD_BUNDLE.get(), (Block)UABlocks.PICKERELWEED_BLOCK.get(), (Block)UABlocks.MULBERRY_PUNNET.get()}).addTag(UABlockTags.STORAGE_BLOCKS_KELP);
        this.tag(UABlockTags.STORAGE_BLOCKS_KELP).add((Object)((Block)UABlocks.KELP_BLOCK.get()));
        CoralType.values().stream().filter(coralType -> !coralType.vanilla() && coralType != CoralType.PRISMARINE).forEach(coralType -> {
            this.tag(BlockTags.CORAL_PLANTS).add((Object)coralType.coral().get());
            this.tag(BlockTags.CORALS).add((Object)coralType.fan().get());
            this.tag(BlockTags.WALL_CORALS).add((Object)coralType.wallFan().get());
            this.tag(BlockTags.CORAL_BLOCKS).add((Object)coralType.coralBlock().get());
        });
    }

    public static Function<Block, Boolean> is(Class<? extends Block> blockClass) {
        return blockClass::isInstance;
    }

    public void tag(TagKey<Block> tagKey, Function<Block, Boolean> condition) {
        this.tag(tagKey, condition, null, new Block[0]);
    }

    public void tag(TagKey<Block> tagKey, Function<Block, Boolean> condition, TagKey<Block> altTagKey, Block ... alts) {
        this.entries.forEach(holder -> {
            Block block = (Block)holder.get();
            IntrinsicHolderTagsProvider.IntrinsicTagAppender appender = this.tag(List.of(alts).contains(block) ? altTagKey : tagKey);
            if (((Boolean)condition.apply(block)).booleanValue()) {
                appender.add((Object)block);
            }
        });
    }
}

