/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.mixin.client;

import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DrownedModel.class})
public class DrownedModelMixin<T extends Zombie>
extends ZombieModel<T> {
    public DrownedModelMixin(ModelPart p_171090_) {
        super(p_171090_);
    }

    @Inject(at={@At(value="TAIL")}, method={"setupAnim(Lnet/minecraft/world/entity/monster/Zombie;FFFFF)V"})
    private void setRotationAngles(T drowned, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo info) {
        if (drowned.isVisuallySwimming() && drowned.isInWater() && drowned.getVehicle() == null && this.getHorizontalMotion(drowned.getDeltaMovement()) >= 0.025f && drowned.getCommandSenderWorld().getFluidState(drowned.blockPosition().below()).is(FluidTags.WATER)) {
            float leftArmSwimAnimTicks;
            float limbSwingRemainder = limbSwing % 26.0f;
            HumanoidArm handside = this.getAttackArm((LivingEntity)drowned);
            float rightArmSwimAnimTicks = handside == HumanoidArm.RIGHT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            float f = leftArmSwimAnimTicks = handside == HumanoidArm.LEFT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            if (limbSwingRemainder < 14.0f) {
                this.leftArm.xRot = this.rotlerpRad(leftArmSwimAnimTicks, this.leftArm.xRot, 0.0f);
                this.rightArm.xRot = Mth.lerp((float)rightArmSwimAnimTicks, (float)this.rightArm.xRot, (float)0.0f);
                this.leftArm.yRot = this.rotlerpRad(leftArmSwimAnimTicks, this.leftArm.yRot, (float)Math.PI);
                this.rightArm.yRot = Mth.lerp((float)rightArmSwimAnimTicks, (float)this.rightArm.yRot, (float)((float)Math.PI));
                this.leftArm.zRot = this.rotlerpRad(leftArmSwimAnimTicks, this.leftArm.zRot, (float)Math.PI + 1.8707964f * this.getArmAngleSq(limbSwingRemainder) / this.getArmAngleSq(14.0f));
                this.rightArm.zRot = Mth.lerp((float)rightArmSwimAnimTicks, (float)this.rightArm.zRot, (float)((float)Math.PI - 1.8707964f * this.getArmAngleSq(limbSwingRemainder) / this.getArmAngleSq(14.0f)));
            } else if (limbSwingRemainder >= 14.0f && limbSwingRemainder < 22.0f) {
                float multiplier1 = (limbSwingRemainder - 14.0f) / 8.0f;
                this.leftArm.xRot = this.rotlerpRad(leftArmSwimAnimTicks, this.leftArm.xRot, 1.5707964f * multiplier1);
                this.rightArm.xRot = Mth.lerp((float)rightArmSwimAnimTicks, (float)this.rightArm.xRot, (float)(1.5707964f * multiplier1));
                this.leftArm.yRot = this.rotlerpRad(leftArmSwimAnimTicks, this.leftArm.yRot, (float)Math.PI);
                this.rightArm.yRot = Mth.lerp((float)rightArmSwimAnimTicks, (float)this.rightArm.yRot, (float)((float)Math.PI));
                this.leftArm.zRot = this.rotlerpRad(leftArmSwimAnimTicks, this.leftArm.zRot, 5.012389f - 1.8707964f * multiplier1);
                this.rightArm.zRot = Mth.lerp((float)rightArmSwimAnimTicks, (float)this.rightArm.zRot, (float)(1.2707963f + 1.8707964f * multiplier1));
            } else if (limbSwingRemainder >= 22.0f && limbSwingRemainder < 26.0f) {
                float multiplier2 = (limbSwingRemainder - 22.0f) / 4.0f;
                this.leftArm.xRot = this.rotlerpRad(leftArmSwimAnimTicks, this.leftArm.xRot, 1.5707964f - 1.5707964f * multiplier2);
                this.rightArm.xRot = Mth.lerp((float)rightArmSwimAnimTicks, (float)this.rightArm.xRot, (float)(1.5707964f - 1.5707964f * multiplier2));
                this.leftArm.yRot = this.rotlerpRad(leftArmSwimAnimTicks, this.leftArm.yRot, (float)Math.PI);
                this.rightArm.yRot = Mth.lerp((float)rightArmSwimAnimTicks, (float)this.rightArm.yRot, (float)((float)Math.PI));
                this.leftArm.zRot = this.rotlerpRad(leftArmSwimAnimTicks, this.leftArm.zRot, (float)Math.PI);
                this.rightArm.zRot = Mth.lerp((float)rightArmSwimAnimTicks, (float)this.rightArm.zRot, (float)((float)Math.PI));
            }
            this.head.xRot = drowned.isVisuallySwimming() ? this.rotlerpRad(this.swimAmount, this.head.xRot, -0.7853982f) : this.rotlerpRad(this.swimAmount, this.head.xRot, headPitch * ((float)Math.PI / 180));
            this.leftLeg.xRot = Mth.lerp((float)this.swimAmount, (float)this.leftLeg.xRot, (float)(0.3f * Mth.cos((float)(limbSwing * 0.33333334f + (float)Math.PI))));
            this.rightLeg.xRot = Mth.lerp((float)this.swimAmount, (float)this.rightLeg.xRot, (float)(0.3f * Mth.cos((float)(limbSwing * 0.33333334f))));
        }
    }

    private float getArmAngleSq(float limbSwing) {
        return -65.0f * limbSwing + limbSwing * limbSwing;
    }

    private float getHorizontalMotion(Vec3 motion) {
        double x = motion.x();
        double z = motion.z();
        return Mth.sqrt((float)((float)(x * x + z * z)));
    }
}

