/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.registry.datapack;

import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;

public class UAPaintingVariants {
    public static final ResourceKey<PaintingVariant> SIGHTLESS = UAPaintingVariants.createKey("sightless");
    public static final ResourceKey<PaintingVariant> MONUMENT = UAPaintingVariants.createKey("monument");
    public static final ResourceKey<PaintingVariant> UTENSIL = UAPaintingVariants.createKey("utensil");
    public static final ResourceKey<PaintingVariant> COIL = UAPaintingVariants.createKey("coil");

    public static void bootstrap(BootstrapContext<PaintingVariant> context) {
        UAPaintingVariants.register(context, SIGHTLESS, 4, 2);
        UAPaintingVariants.register(context, MONUMENT, 4, 3);
        UAPaintingVariants.register(context, UTENSIL, 1, 1);
        UAPaintingVariants.register(context, COIL, 3, 4);
    }

    private static ResourceKey<PaintingVariant> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PAINTING_VARIANT, (ResourceLocation)UpgradeAquatic.location(name));
    }

    private static void register(BootstrapContext<PaintingVariant> context, ResourceKey<PaintingVariant> key, int width, int height) {
        context.register(key, (Object)new PaintingVariant(width, height, key.location()));
    }
}

