/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs;

import java.net.URI;

public abstract class AbstractPatch {
    public String name() {
        return this.getClass().getSimpleName();
    }

    public abstract String platform();

    public abstract boolean isValid(URI var1);

    public Result patch(URI uri, Quality prefQuality) throws FixingURLException {
        if (!this.isValid(uri)) {
            throw new FixingURLException(uri, (Throwable)new IllegalArgumentException("Attempt to build a invalid URL in a invalid Compat"));
        }
        return null;
    }

    public String toString() {
        return this.name();
    }

    public static final class FixingURLException
    extends Exception {
        public FixingURLException(String url, Throwable t) {
            super("Failed to fix URL " + url, t);
        }

        public FixingURLException(URI url, Throwable t) {
            super("Failed to fix URL " + url.toString(), t);
        }
    }

    public static enum Quality {
        LOWEST,
        LOW,
        MIDDLE,
        HIGH,
        HIGHEST;

    }

    public static class Result {
        private static final FallbackResult DEFAULT_FALLBACK = uri -> null;
        public final URI uri;
        public URI audioUrl;
        public final Quality quality;
        public final FallbackResult fallbackResult;
        public final boolean assumeStream;
        public final boolean assumeVideo;

        public Result(URI uri, boolean assumeVideo, boolean assumeStream) {
            this(uri, assumeVideo, assumeStream, DEFAULT_FALLBACK);
        }

        public Result(URI uri, boolean assumeVideo, boolean assumeStream, FallbackResult fallback) {
            this.uri = uri;
            this.quality = null;
            this.assumeVideo = assumeVideo;
            this.assumeStream = assumeStream;
            this.fallbackResult = fallback;
        }

        public Result setAudioTrack(URI url) {
            this.audioUrl = url;
            return this;
        }

        public String toString() {
            return "Result{url=" + this.uri + ", audioUrl=" + this.audioUrl + ", quality=" + (Object)((Object)this.quality) + ", assumeStream=" + this.assumeStream + ", assumeVideo=" + this.assumeVideo + '}';
        }
    }

    public static interface FallbackResult {
        public Result compute(URI var1) throws FixingURLException;
    }
}

