/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URI;
import org.watermedia.api.network.patchs.AbstractPatch;
import org.watermedia.api.network.patchs.twitch.TwitchAPI;

public class TwitchPatch
extends AbstractPatch {
    @Override
    public String platform() {
        return "Twitch";
    }

    @Override
    public boolean isValid(URI uri) {
        String host = uri.getHost();
        String path = uri.getPath();
        return host != null && (host.equals("www.twitch.tv") || host.equals("twitch.tv")) && path != null && path.startsWith("/");
    }

    @Override
    public AbstractPatch.Result patch(URI uri, AbstractPatch.Quality preferQuality) throws AbstractPatch.FixingURLException {
        super.patch(uri, preferQuality);
        try {
            String path = uri.getPath();
            if (path.startsWith("/videos/")) {
                return new AbstractPatch.Result(new URI(TwitchAPI.getVod(path.substring(8)).get(0).getUrl()), true, false);
            }
            return new AbstractPatch.Result(new URI(TwitchAPI.getStream(path.substring(1)).get(0).getUrl()), true, true);
        }
        catch (Exception e) {
            throw new AbstractPatch.FixingURLException(uri, (Throwable)e);
        }
    }

    static {
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
    }
}

