/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader.downloader.request;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.watermedia.shaded.kiulian.downloader.downloader.YoutubeCallback;
import org.watermedia.shaded.kiulian.downloader.downloader.client.Client;
import org.watermedia.shaded.kiulian.downloader.downloader.client.DefaultClients;
import org.watermedia.shaded.kiulian.downloader.downloader.proxy.ProxyAuthenticator;
import org.watermedia.shaded.kiulian.downloader.downloader.proxy.ProxyCredentialsImpl;

public abstract class Request<T extends Request<T, S>, S> {
    protected Map<String, String> headers;
    private YoutubeCallback<S> callback;
    private boolean async;
    private int retries;
    private Proxy proxy;
    private Client client = DefaultClients.defaultClient();

    public T proxy(String host, int port) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        return (T)this;
    }

    public T proxy(String host, int port, String userName, String password) {
        if (ProxyAuthenticator.getDefault() == null) {
            ProxyAuthenticator.setDefault(new ProxyAuthenticator(new ProxyCredentialsImpl()));
        }
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        ProxyAuthenticator.addAuthentication(host, port, userName, password);
        return (T)this;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public T retries(int maxRetries) {
        this.retries = maxRetries;
        return (T)this;
    }

    public int getRetries() {
        return this.retries;
    }

    public T callback(YoutubeCallback<S> callback) {
        this.callback = callback;
        return (T)this;
    }

    public YoutubeCallback<S> getCallback() {
        return this.callback;
    }

    public T header(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return (T)this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public T async() {
        this.async = true;
        return (T)this;
    }

    public boolean isAsync() {
        return this.async;
    }

    public T client(Client client) {
        this.client = client;
        return (T)this;
    }

    public Client getClient() {
        return this.client;
    }
}

