/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.component;

import java.awt.Window;
import org.watermedia.videolan4j.factory.MediaPlayerFactory;
import org.watermedia.videolan4j.player.component.AudioListPlayerComponent;
import org.watermedia.videolan4j.player.component.AudioPlayerComponent;
import org.watermedia.videolan4j.player.component.CallbackMediaListPlayerComponent;
import org.watermedia.videolan4j.player.component.CallbackMediaPlayerComponent;
import org.watermedia.videolan4j.player.component.InputEvents;
import org.watermedia.videolan4j.player.component.callback.CallbackImagePainter;
import org.watermedia.videolan4j.player.embedded.fullscreen.FullScreenStrategy;
import org.watermedia.videolan4j.player.embedded.fullscreen.adaptive.AdaptiveFullScreenStrategy;
import org.watermedia.videolan4j.player.embedded.fullscreen.unsupported.UnsupportedFullScreenStrategy;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferCleanupCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormatCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.RenderCallback;

public final class MediaPlayerSpecs {
    public static CallbackMediaPlayerSpec callbackMediaPlayerSpec() {
        return new CallbackMediaPlayerSpec();
    }

    public static AudioPlayerSpec audioPlayerSpec() {
        return new AudioPlayerSpec();
    }

    public static final class CallbackMediaPlayerSpec {
        MediaPlayerFactory factory;
        FullScreenStrategy fullScreenStrategy;
        InputEvents inputEvents;
        boolean lockedBuffers = true;
        CallbackImagePainter imagePainter;
        RenderCallback renderCallback;
        BufferFormatCallback bufferFormatCallback;
        BufferCleanupCallback cleanupCallback;

        public CallbackMediaPlayerSpec withFactory(MediaPlayerFactory factory) {
            this.factory = factory;
            return this;
        }

        public CallbackMediaPlayerSpec withFullScreenStrategy(FullScreenStrategy fullScreenStrategy) {
            this.fullScreenStrategy = fullScreenStrategy;
            return this;
        }

        public CallbackMediaPlayerSpec withDefaultFullScreenStrategy(Window fullScreenWindow) {
            this.fullScreenStrategy = new AdaptiveFullScreenStrategy(fullScreenWindow);
            return this;
        }

        public CallbackMediaPlayerSpec withUnsupportedFullScreenStrategy() {
            this.fullScreenStrategy = new UnsupportedFullScreenStrategy();
            return this;
        }

        public CallbackMediaPlayerSpec withInputEvents(InputEvents inputEvents) {
            this.inputEvents = inputEvents;
            return this;
        }

        public CallbackMediaPlayerSpec withLockedBuffers(boolean lockedBuffers) {
            this.lockedBuffers = lockedBuffers;
            return this;
        }

        public CallbackMediaPlayerSpec withLockedBuffers() {
            this.lockedBuffers = true;
            return this;
        }

        public CallbackMediaPlayerSpec withImagePainter(CallbackImagePainter imagePainter) {
            this.imagePainter = imagePainter;
            return this;
        }

        public CallbackMediaPlayerSpec withRenderCallback(RenderCallback renderCallback) {
            this.renderCallback = renderCallback;
            return this;
        }

        public CallbackMediaPlayerSpec withBufferFormatCallback(BufferFormatCallback bufferFormatCallback) {
            this.bufferFormatCallback = bufferFormatCallback;
            return this;
        }

        public CallbackMediaPlayerComponent callbackMediaPlayer() {
            return new CallbackMediaPlayerComponent(this);
        }

        public CallbackMediaListPlayerComponent callbackMediaListPlayer() {
            return new CallbackMediaListPlayerComponent(this);
        }

        private CallbackMediaPlayerSpec() {
        }
    }

    public static final class AudioPlayerSpec {
        MediaPlayerFactory factory;

        public AudioPlayerSpec withFactory(MediaPlayerFactory factory) {
            this.factory = factory;
            return this;
        }

        public AudioPlayerComponent audioPlayer() {
            return new AudioPlayerComponent(this);
        }

        public AudioListPlayerComponent audioListPlayer() {
            return new AudioListPlayerComponent(this);
        }

        private AudioPlayerSpec() {
        }
    }
}

