/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.embedded.fullscreen.adaptive;

import com.sun.jna.Platform;
import java.awt.Window;
import org.watermedia.videolan4j.player.embedded.fullscreen.FullScreenStrategy;
import org.watermedia.videolan4j.player.embedded.fullscreen.exclusivemode.ExclusiveModeFullScreenStrategy;
import org.watermedia.videolan4j.player.embedded.fullscreen.windows.Win32FullScreenStrategy;
import org.watermedia.videolan4j.player.embedded.fullscreen.x.XFullScreenStrategy;

public class AdaptiveFullScreenStrategy
implements FullScreenStrategy {
    private final FullScreenStrategy strategy;

    public AdaptiveFullScreenStrategy(Window window) {
        this.strategy = this.getStrategy(window);
    }

    @Override
    public final void enterFullScreenMode() {
        this.onBeforeEnterFullScreen();
        this.strategy.enterFullScreenMode();
    }

    @Override
    public final void exitFullScreenMode() {
        this.strategy.exitFullScreenMode();
        this.onAfterExitFullScreen();
    }

    @Override
    public final boolean isFullScreenMode() {
        return this.strategy.isFullScreenMode();
    }

    protected void onBeforeEnterFullScreen() {
    }

    protected void onAfterExitFullScreen() {
    }

    private FullScreenStrategy getStrategy(Window window) {
        if (Platform.isLinux()) {
            return new XFullScreenStrategy(window);
        }
        if (Platform.isWindows()) {
            return new Win32FullScreenStrategy(window);
        }
        return new ExclusiveModeFullScreenStrategy(window);
    }
}

