/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.isxander.yacl3.debug.DebugProperties;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class GuiUtils {
    private static Function<ResourceLocation, RenderType> GUI_TEXTURED = Util.memoize(location -> RenderType.create((String)"yacl:gui_textured", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionTexColorShader)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).createCompositeState(false)));

    public static void pushPose(GuiGraphics graphics) {
        graphics.pose().pushPose();
    }

    public static void popPose(GuiGraphics graphics) {
        graphics.pose().popPose();
    }

    public static void translate2D(GuiGraphics graphics, float x, float y) {
        graphics.pose().translate(x, y, 0.0f);
    }

    public static void translateZ(GuiGraphics graphics, float z) {
        graphics.pose().translate(0.0f, 0.0f, z);
    }

    public static void scale2D(GuiGraphics graphics, float x, float y) {
        graphics.pose().scale(x, y, 1.0f);
    }

    public static void rotate2D(GuiGraphics graphics, float angle) {
        graphics.pose().rotateAround(Axis.ZP.rotationDegrees(angle), 0.0f, 0.0f, 1.0f);
    }

    public static void blitGuiTex(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height) {
        GuiUtils.blitGuiTex(graphics, texture, x, y, u, v, textureWidth, textureHeight, width, height, false);
    }

    public static void blitGuiTex(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height, boolean linearFiltering) {
        GuiUtils.doTextureFiltering();
        graphics.blit(texture, x, y, u, v, textureWidth, textureHeight, width, height);
    }

    public static void blitGuiTexColor(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        graphics.setColor(r, g, b, a);
        graphics.blit(texture, x, y, u, v, textureWidth, textureHeight, width, height);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void blitSprite(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        graphics.blitSprite(sprite, x, y, width, height);
    }

    public static Function<ResourceLocation, RenderType> guiTextured(boolean textureFiltering) {
        return GUI_TEXTURED;
    }

    public static MutableComponent translatableFallback(String key, Component fallback) {
        if (Language.getInstance().has(key)) {
            return Component.translatable((String)key);
        }
        return fallback.copy();
    }

    public static String shortenString(String string, Font font, int maxWidth, String suffix) {
        if (((String)string).isEmpty()) {
            return string;
        }
        boolean firstIter = true;
        while (font.width((String)string) > maxWidth) {
            string = ((String)string).substring(0, Math.max(((String)string).length() - 1 - (firstIter ? 1 : suffix.length() + 1), 0)).trim();
            if (((String)(string = (String)string + suffix)).equals(suffix)) break;
            firstIter = false;
        }
        return string;
    }

    public static void setPixelARGB(NativeImage nativeImage, int x, int y, int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        int abgr = a << 24 | b << 16 | g << 8 | r;
        nativeImage.setPixelRGBA(x, y, abgr);
    }

    public static void doTextureFiltering() {
        if (DebugProperties.IMAGE_FILTERING) {
            GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
        }
    }

    public static int extractAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int putAlpha(int rgb, int alpha) {
        return rgb & 0xFFFFFF | alpha << 24;
    }
}

