/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank.blaze_banker;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import dev.ithundxr.createnumismatics.base.block.ConditionalBreak;
import dev.ithundxr.createnumismatics.base.block.NotifyFailedBreak;
import dev.ithundxr.createnumismatics.content.backend.TrustedBlock;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlazeBankerBlock
extends Block
implements IWrenchable,
IBE<BlazeBankerBlockEntity>,
TrustedBlock,
NotifyFailedBreak,
ConditionalBreak {
    public BlazeBankerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<BlazeBankerBlockEntity> getBlockEntityClass() {
        return BlazeBankerBlockEntity.class;
    }

    public BlockEntityType<? extends BlazeBankerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NumismaticsBlockEntities.BLAZE_BANKER.get();
    }

    @Override
    public void notifyFailedBreak(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlazeBankerBlockEntity) {
            BlazeBankerBlockEntity blazeBankerBE = (BlazeBankerBlockEntity)blockEntity;
            blazeBankerBE.notifyDelayedDataSync();
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    @Override
    public boolean mayBreak(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        return this.mayBreak(level, pos, state, player, false);
    }

    private boolean mayBreak(LevelAccessor level, BlockPos pos, BlockState state, Player player, boolean forDestroyProgress) {
        if (level.m_5776_() && !forDestroyProgress) {
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BlazeBankerBlockEntity)) {
            return true;
        }
        BlazeBankerBlockEntity blazeBankerBE = (BlazeBankerBlockEntity)blockEntity;
        if (level.m_5776_()) {
            return blazeBankerBE.getClientsideBalance() == 0;
        }
        return !blazeBankerBE.hasAccount() || blazeBankerBE.getAccount().getBalance() == 0;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            if (be.owner == null) {
                be.owner = player.m_20148_();
                be.notifyUpdate();
            }
        });
        if (this.isTrusted(player, (BlockGetter)level, pos)) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> be.openTrustListMenu((ServerPlayer)player));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof BlazeBankerBlockEntity) {
                BlazeBankerBlockEntity blazeBankerBE = (BlazeBankerBlockEntity)blockEntity;
                blazeBankerBE.owner = player.m_20148_();
            }
        }
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (!this.isTrusted(context.m_43723_(), (BlockGetter)context.m_43725_(), context.m_8083_())) {
            return InteractionResult.FAIL;
        }
        return super.onSneakWrenched(state, context);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return AllShapes.HEATER_BLOCK_SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (context == CollisionContext.m_82749_()) {
            return AllShapes.HEATER_BLOCK_SPECIAL_COLLISION_SHAPE;
        }
        return this.m_5940_(state, level, pos, context);
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, RandomSource random) {
        if (random.m_188503_(10) != 0) {
            return;
        }
        world.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
    }

    public float m_5880_(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        if (!this.isTrusted(player, level, pos) || !this.mayBreak((LevelAccessor)player.m_9236_(), pos, state, player, true)) {
            return 0.0f;
        }
        return super.m_5880_(state, player, level, pos);
    }
}

