/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.client.audio;

import com.mrbysco.disccord.DiscCordMod;
import com.mrbysco.disccord.client.audio.PathTools;
import com.mrbysco.disccord.config.DiscCordConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.SystemUtils;

public class YoutubeDL {
    static String youtubedlPath = null;

    static void checkForExecutable() throws IOException {
        String fileName = switch (Util.m_137581_()) {
            case Util.OS.LINUX -> "yt-dlp_linux";
            case Util.OS.OSX -> "yt-dlp_macos";
            default -> "yt-dlp.exe";
        };
        Optional<String> pathExecutable = PathTools.traversePath("yt-dlp");
        if (!pathExecutable.isEmpty()) {
            youtubedlPath = pathExecutable.get().toString();
            return;
        }
        File YoutubeDLDirectory = FMLPaths.CONFIGDIR.get().resolve("disccord/youtubedl/").toAbsolutePath().toFile();
        if (!YoutubeDLDirectory.exists() && !YoutubeDLDirectory.mkdirs()) {
            DiscCordMod.LOGGER.error("Failed to create the 'disccord/youtubedl' directory");
            return;
        }
        File ffmpegFile = YoutubeDLDirectory.toPath().resolve(fileName).toFile();
        Minecraft mc = Minecraft.m_91087_();
        if (!ffmpegFile.exists()) {
            if (((Boolean)DiscCordConfig.CLIENT.downloadYoutubeDL.get()).booleanValue()) {
                InputStream inputStream = null;
                if (SystemUtils.IS_OS_LINUX) {
                    inputStream = new URL("https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_linux").openStream();
                } else if (SystemUtils.IS_OS_MAC) {
                    inputStream = new URL("https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_macos").openStream();
                } else if (SystemUtils.IS_OS_WINDOWS) {
                    inputStream = new URL("https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp.exe").openStream();
                }
                if (inputStream != null) {
                    Path outPath = YoutubeDLDirectory.toPath().resolve(fileName);
                    Files.copy(inputStream, outPath, StandardCopyOption.REPLACE_EXISTING);
                    youtubedlPath = outPath.toString();
                    outPath.toFile().setExecutable(true);
                } else {
                    DiscCordMod.LOGGER.error("Failed to download the yt-dlp executable");
                }
            } else {
                if (mc.f_91074_ != null) {
                    mc.f_91074_.m_213846_((Component)Component.m_237115_((String)"disccord.youtubedl.missing").m_130940_(ChatFormatting.RED));
                }
                for (String message : YoutubeDL.getMissingMessage()) {
                    DiscCordMod.LOGGER.error(message);
                }
            }
        } else if (SystemUtils.IS_OS_WINDOWS || ffmpegFile.canExecute()) {
            youtubedlPath = ffmpegFile.getAbsolutePath();
        } else {
            if (mc.f_91074_ != null) {
                mc.f_91074_.m_213846_((Component)Component.m_237110_((String)"disccord.executable.permission", (Object[])new Object[]{ffmpegFile.getName()}).m_130940_(ChatFormatting.RED));
            }
            DiscCordMod.LOGGER.error("The '{}' executable isn't executeable, please make sure to add the executeable permission with chmod +x", (Object)ffmpegFile.getName());
        }
    }

    static String executeYoutubeDLCommand(String ... arguments) throws IOException, InterruptedException {
        Process resultProcess;
        if (youtubedlPath == null || !new File(youtubedlPath).canExecute()) {
            YoutubeDL.checkForExecutable();
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(youtubedlPath);
        Collections.addAll(cmdList, arguments);
        DiscCordMod.LOGGER.debug("Executing '{}'", (Object)String.join((CharSequence)" ", cmdList));
        if (SystemUtils.IS_OS_LINUX) {
            String cmd = String.join((CharSequence)" ", cmdList);
            String[] cmds = new String[]{"/bin/sh", "-c", cmd};
            resultProcess = Runtime.getRuntime().exec(cmds);
        } else {
            resultProcess = Runtime.getRuntime().exec(cmdList.toArray(new String[0]));
        }
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(resultProcess.getInputStream()));
        Object output = "";
        String s = null;
        while ((s = stdInput.readLine()) != null) {
            output = (String)output + s;
        }
        int result = resultProcess.waitFor();
        if (result != 0) {
            BufferedReader stdError = new BufferedReader(new InputStreamReader(resultProcess.getErrorStream()));
            StringBuilder errorOutput = new StringBuilder();
            while ((s = stdError.readLine()) != null) {
                errorOutput.append(s).append("\n");
            }
            DiscCordMod.LOGGER.error("yt-dlp error output: {}", (Object)errorOutput.toString());
            throw new IOException("Process exited with error code " + result);
        }
        return output;
    }

    static String[] getMissingMessage() {
        return new String[]{"ERROR: 'yt-dlp' executable wasn't found in the 'config/disccord/youtubedl' folder!", "Please visit one of the following URLs to download it:", " - https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp.exe (Windows)", " - https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_linux (Linux)", " - https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_macos (Mac OS)", "", "Place the downloaded executable in the 'config/disccord/youtubedl' folder"};
    }
}

