/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.network.payload;

import com.mrbysco.disccord.config.DiscCordConfig;
import com.mrbysco.disccord.registry.ModRegistry;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record SetRecordUrlMessage(String url) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.url);
    }

    public static SetRecordUrlMessage decode(FriendlyByteBuf packetBuffer) {
        return new SetRecordUrlMessage(packetBuffer.m_130277_());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isServer()) {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                ItemStack currentItem = player.m_21120_(player.m_7655_());
                if (!currentItem.m_150930_((Item)ModRegistry.CUSTOM_RECORD.get())) {
                    return;
                }
                try {
                    new URL(this.url()).toURI();
                }
                catch (Exception e) {
                    player.m_213846_((Component)Component.m_237115_((String)"disccord.song_url.invalid"));
                    return;
                }
                if (this.url().length() >= 400) {
                    player.m_213846_((Component)Component.m_237115_((String)"disccord.song_url.long"));
                    return;
                }
                for (String url : (List)DiscCordConfig.SERVER.whitelistedUrls.get()) {
                    if (!this.url().startsWith(url)) continue;
                    player.m_6330_(SoundEvents.f_12565_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    CompoundTag tag = currentItem.m_41784_();
                    tag.m_128359_("disccord:url", this.url());
                    currentItem.m_41751_(tag);
                    return;
                }
                player.m_213846_((Component)Component.m_237115_((String)"disccord.song_url.websites").m_130946_(",").m_130946_(((List)DiscCordConfig.SERVER.whitelistedWebsites.get()).toString()));
            }
        });
        ctx.setPacketHandled(true);
    }
}

