/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.fungidelight.common.entity.ai.pig;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import net.mehdinoui.fungidelight.Configuration;
import net.mehdinoui.fungidelight.common.registry.ModItems;
import net.mehdinoui.fungidelight.common.registry.ModSoundEvents;
import net.mehdinoui.fungidelight.common.tag.FungiDelightTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class TruffleDiggingGoal
extends Goal {
    private final Pig pig;
    private final Level level;
    private BlockPos targetBlock = null;
    public static final ResourceLocation DIGGING_LOOT = new ResourceLocation("fungidelight", "gameplay/pig_digging");
    private int digTime = 0;
    private int offBlockTimer = 0;
    private int cooldown = 0;
    private boolean hasFinishedDigging = false;
    private static final int SEARCH_RADIUS = 6;
    private static final int DIG_DURATION = 60;
    private static final int MAX_GIVE_UP_TICKS = 120;

    public TruffleDiggingGoal(Pig pig) {
        this.pig = pig;
        this.level = pig.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private void lookAtTarget() {
        if (this.targetBlock != null) {
            this.pig.m_21563_().m_24950_((double)this.targetBlock.m_123341_() + 0.5, (double)this.targetBlock.m_123342_() + 0.5, (double)this.targetBlock.m_123343_() + 0.5, 10.0f, (float)this.pig.m_8132_());
        }
    }

    private void navigateToTarget() {
        if (this.targetBlock != null) {
            this.pig.m_21573_().m_26519_((double)this.targetBlock.m_123341_() + 0.5, (double)this.targetBlock.m_123342_() + 1.0, (double)this.targetBlock.m_123343_() + 0.5, 1.0);
        }
    }

    private BlockPos findDiggableBlock() {
        BlockPos origin = this.pig.m_20183_();
        BlockPos best = null;
        double bestDist = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-6, -1, -6), (BlockPos)origin.m_7918_(6, 1, 6))) {
            double dist;
            if (!this.level.m_8055_(pos).m_204336_(FungiDelightTags.PIG_CAN_DIG_UP) || !this.level.m_46859_(pos.m_7494_()) || !((dist = pos.m_123331_((Vec3i)origin)) < bestDist)) continue;
            bestDist = dist;
            best = pos.m_7949_();
        }
        return best;
    }

    private void dropLoot() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState state = this.level.m_8055_(this.targetBlock);
        if (state.m_204336_(FungiDelightTags.TRUFFLE_ORE)) {
            int count = 1 + this.level.f_46441_.m_188503_(3);
            ItemStack truffles = new ItemStack((ItemLike)ModItems.TRUFFLE.get(), count);
            ItemEntity itemEntity = new ItemEntity(this.level, (double)this.targetBlock.m_123341_() + 0.5, (double)this.targetBlock.m_123342_() + 1.0, (double)this.targetBlock.m_123343_() + 0.5, truffles);
            itemEntity.m_20334_(0.0, 0.25, 0.0);
            this.level.m_7967_((Entity)itemEntity);
        } else {
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(DIGGING_LOOT);
            ObjectArrayList items = lootTable.m_287195_(new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)this.pig.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.pig).m_287235_(LootContextParamSets.f_81417_));
            for (ItemStack item : items) {
                ItemEntity itemEntity = new ItemEntity(this.level, (double)this.targetBlock.m_123341_() + 0.5, (double)this.targetBlock.m_123342_() + 1.0, (double)this.targetBlock.m_123343_() + 0.5, item);
                itemEntity.m_20334_(0.0, 0.25, 0.0);
                this.level.m_7967_((Entity)itemEntity);
            }
        }
    }

    public boolean m_8036_() {
        if (!((Boolean)Configuration.ENABLE_PIG_DIGGING.get()).booleanValue()) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (!this.level.m_220393_(this.pig.m_20183_())) {
            return false;
        }
        if (!this.pig.m_20096_() || this.pig.m_6162_()) {
            return false;
        }
        if (this.level.f_46441_.m_188501_() >= ((Double)Configuration.CHANCE_PIG_DIGGING.get()).floatValue()) {
            return false;
        }
        this.targetBlock = this.findDiggableBlock();
        return this.targetBlock != null;
    }

    public boolean m_8045_() {
        boolean targetBlockStillValid = this.targetBlock != null && this.level.m_8055_(this.targetBlock).m_204336_(FungiDelightTags.PIG_CAN_DIG_UP);
        return this.digTime > 0 && targetBlockStillValid && this.pig.f_20916_ <= 0 && this.pig.m_20096_() && this.offBlockTimer < 120 && !this.hasFinishedDigging;
    }

    public void m_8056_() {
        this.digTime = 60;
        this.offBlockTimer = 0;
        this.hasFinishedDigging = false;
        this.pig.m_21573_().m_26573_();
        this.navigateToTarget();
        this.level.m_6269_(null, (Entity)this.pig, (SoundEvent)ModSoundEvents.PIG_HAPPY.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.lookAtTarget();
    }

    public void m_8037_() {
        double dz;
        if (this.targetBlock == null) {
            return;
        }
        Vec3 targetCenter = new Vec3((double)this.targetBlock.m_123341_() + 0.5, (double)this.targetBlock.m_123342_() + 1.0, (double)this.targetBlock.m_123343_() + 0.5);
        double dx = this.pig.m_20185_() - targetCenter.f_82479_;
        double distSqrHorizontal = dx * dx + (dz = this.pig.m_20189_() - targetCenter.f_82481_) * dz;
        if (distSqrHorizontal > 2.25) {
            ++this.offBlockTimer;
            if (this.pig.m_21573_().m_26571_() || this.offBlockTimer % 10 == 0) {
                this.navigateToTarget();
            }
            return;
        }
        this.offBlockTimer = 0;
        this.pig.m_21573_().m_26573_();
        this.lookAtTarget();
        if (this.targetBlock == null || !this.level.m_8055_(this.targetBlock).m_204336_(FungiDelightTags.PIG_CAN_DIG_UP)) {
            this.digTime = 0;
            return;
        }
        this.digTime = Math.max(0, this.digTime - 1);
        if (this.digTime > 0) {
            Level level;
            if (this.digTime % 5 == 0) {
                this.level.m_7605_((Entity)this.pig, (byte)10);
            }
            if (this.digTime % 5 == 0 && (level = this.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockState blockState = this.level.m_8055_(this.targetBlock);
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)this.targetBlock.m_123341_() + 0.5, (double)this.targetBlock.m_123342_() + 1.0, (double)this.targetBlock.m_123343_() + 0.5, 6, 0.3, 0.1, 0.3, 0.15);
                this.level.m_5594_(null, this.targetBlock, (SoundEvent)ModSoundEvents.PIG_DIG.get(), SoundSource.NEUTRAL, 0.5f, 0.8f);
            }
        } else {
            this.hasFinishedDigging = true;
        }
    }

    public void m_8041_() {
        if (this.hasFinishedDigging && this.targetBlock != null && this.level.m_8055_(this.targetBlock).m_204336_(FungiDelightTags.PIG_CAN_DIG_UP)) {
            this.level.m_5594_(null, this.targetBlock, SoundEvents.f_215708_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.level.m_5594_(null, this.targetBlock, (SoundEvent)ModSoundEvents.PIG_DROP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.dropLoot();
            this.level.m_46597_(this.targetBlock, Blocks.f_50546_.m_49966_());
            this.cooldown = 2400;
        } else {
            this.cooldown = 200;
        }
        this.targetBlock = null;
        this.hasFinishedDigging = false;
        this.pig.m_21573_().m_26573_();
    }
}

