/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.fungidelight.common.entity.ai.wolf;

import java.util.EnumSet;
import net.mehdinoui.fungidelight.Configuration;
import net.mehdinoui.fungidelight.common.registry.ModSoundEvents;
import net.mehdinoui.fungidelight.common.tag.FungiDelightTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DogTruffleHuntGoal
extends Goal {
    private final Wolf wolf;
    private final Level level;
    private BlockPos targetTrufflePos;
    private BlockPos targetSurfacePos;
    private int barkTimer = 9;
    private int offBlockTimer = 9;
    private static final int SEARCH_RADIUS = 12;
    private static final int SEARCH_DEPTH = 4;
    private static final int SUCCESS_TIME = 40;
    private static final int MAX_GIVE_UP_TICKS = 100;

    public DogTruffleHuntGoal(Wolf wolf) {
        this.wolf = wolf;
        this.level = wolf.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private boolean isHunting() {
        if (!this.wolf.getPersistentData().m_128441_("fungidelight.dog_hunting_timer")) {
            return false;
        }
        long endTime = this.wolf.getPersistentData().m_128454_("fungidelight.dog_hunting_timer");
        return this.level.m_46467_() < endTime;
    }

    private void completeHunt() {
        this.wolf.getPersistentData().m_128473_("fungidelight.dog_hunting_timer");
    }

    private BlockPos findNearestTruffle() {
        BlockPos origin = this.wolf.m_20183_();
        BlockPos best = null;
        double bestDist = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-12, -4, -12), (BlockPos)origin.m_7918_(12, -1, 12))) {
            double dist;
            if (!this.level.m_8055_(pos).m_204336_(FungiDelightTags.TRUFFLE_ORE) || !((dist = pos.m_123331_((Vec3i)origin)) < bestDist)) continue;
            bestDist = dist;
            best = pos.m_7949_();
        }
        return best;
    }

    public boolean m_8036_() {
        if (!((Boolean)Configuration.ENABLE_WOLF_HUNT_TRUFFLE.get()).booleanValue()) {
            return false;
        }
        if (!this.wolf.m_21824_() || this.wolf.m_21827_() || this.wolf.m_5448_() != null || !this.isHunting()) {
            return false;
        }
        this.targetTrufflePos = this.findNearestTruffle();
        return this.targetTrufflePos != null;
    }

    public boolean m_8045_() {
        boolean targetBlockStillValid = this.targetTrufflePos != null && this.level.m_8055_(this.targetTrufflePos).m_204336_(FungiDelightTags.TRUFFLE_ORE);
        return this.isHunting() && targetBlockStillValid && !this.wolf.m_21827_() && this.offBlockTimer < 100 && this.wolf.m_5448_() == null;
    }

    public void m_8056_() {
        boolean pathSuccess;
        this.barkTimer = 0;
        this.offBlockTimer = 0;
        this.targetSurfacePos = this.targetTrufflePos.m_7494_();
        while (this.level.m_8055_(this.targetSurfacePos).m_60804_((BlockGetter)this.level, this.targetSurfacePos)) {
            this.targetSurfacePos = this.targetSurfacePos.m_7494_();
            if (this.targetSurfacePos.m_123342_() <= this.targetTrufflePos.m_123342_() + 5) continue;
        }
        if (!(pathSuccess = this.wolf.m_21573_().m_26519_((double)this.targetSurfacePos.m_123341_() + 0.5, (double)this.targetSurfacePos.m_123342_(), (double)this.targetSurfacePos.m_123343_() + 0.5, 1.2))) {
            this.offBlockTimer = 100;
            this.wolf.m_21573_().m_26573_();
        }
        this.wolf.m_216990_((SoundEvent)ModSoundEvents.DOG_FOUND_TRUFFLE.get());
    }

    public void m_8037_() {
        Level level;
        if (this.targetSurfacePos == null || !((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double distSqr = this.wolf.m_20275_((double)this.targetSurfacePos.m_123341_() + 0.5, (double)this.targetSurfacePos.m_123342_(), (double)this.targetSurfacePos.m_123343_() + 0.5);
        if (distSqr > 2.5) {
            boolean pathSuccess;
            ++this.offBlockTimer;
            if ((this.wolf.m_21573_().m_26571_() || this.offBlockTimer % 20 == 0) && !(pathSuccess = this.wolf.m_21573_().m_26519_((double)this.targetSurfacePos.m_123341_() + 0.5, (double)this.targetSurfacePos.m_123342_(), (double)this.targetSurfacePos.m_123343_() + 0.5, 1.2))) {
                this.offBlockTimer += 10;
            }
            return;
        }
        this.offBlockTimer = 0;
        this.wolf.m_21573_().m_26573_();
        this.wolf.m_21563_().m_24950_((double)this.targetSurfacePos.m_123341_() + 0.5, (double)this.targetSurfacePos.m_123342_() - 0.5, (double)this.targetSurfacePos.m_123343_() + 0.5, 10.0f, (float)this.wolf.m_8132_());
        if (this.targetTrufflePos == null || !this.level.m_8055_(this.targetTrufflePos).m_204336_(FungiDelightTags.TRUFFLE_ORE)) {
            this.barkTimer = 0;
            return;
        }
        if (this.barkTimer == 0) {
            this.wolf.m_216990_((SoundEvent)ModSoundEvents.DOG_ALERT_TRUFFLE.get());
        }
        if (this.barkTimer % 5 == 0) {
            BlockState blockState = this.level.m_8055_(this.targetSurfacePos.m_7495_());
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)this.targetSurfacePos.m_123341_() + 0.5, (double)this.targetSurfacePos.m_123342_() + 0.2, (double)this.targetSurfacePos.m_123343_() + 0.5, 6, 0.3, 0.1, 0.3, 0.15);
        }
        ++this.barkTimer;
        if (this.barkTimer > 40) {
            this.completeHunt();
        }
    }

    public void m_8041_() {
        if (this.barkTimer <= 40) {
            this.completeHunt();
        }
        this.targetTrufflePos = null;
        this.targetSurfacePos = null;
        this.barkTimer = 0;
        this.offBlockTimer = 0;
        this.wolf.m_21573_().m_26573_();
    }
}

