/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.fungidelight.common.event;

import java.util.List;
import java.util.Objects;
import net.mehdinoui.fungidelight.Configuration;
import net.mehdinoui.fungidelight.common.registry.ModEffects;
import net.mehdinoui.fungidelight.common.tag.FungiDelightTags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="fungidelight")
public class ModEffectEvents {
    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!((Boolean)Configuration.ENABLE_BURROWING_EFFECT.get()).booleanValue()) {
            return;
        }
        if (!event.getEntity().m_21023_((MobEffect)ModEffects.BURROWING.get())) {
            return;
        }
        if (event.getState().m_204336_(BlockTags.f_144283_)) {
            int amplifier = Objects.requireNonNull(event.getEntity().m_21124_((MobEffect)ModEffects.BURROWING.get())).m_19564_();
            float multiplier = 1.5f + 0.5f * (float)amplifier;
            event.setNewSpeed(event.getOriginalSpeed() * multiplier);
        }
    }

    @SubscribeEvent
    public static void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        if (!((Boolean)Configuration.ENABLE_WEAK_STOMACH_EFFECT.get()).booleanValue()) {
            return;
        }
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        ItemStack consumedItem = event.getItem();
        if (event.getEntity().m_21023_((MobEffect)ModEffects.WEAK_STOMACH.get())) {
            boolean isConfigured;
            ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)consumedItem.m_41720_());
            boolean isPotion = consumedItem.m_41720_() instanceof PotionItem && PotionUtils.m_43579_((ItemStack)consumedItem) != Potions.f_43599_;
            boolean isAlcohol = consumedItem.m_204117_(FungiDelightTags.ALCOHOL);
            boolean bl = isConfigured = itemID != null && ((List)Configuration.WEAK_STOMACH_ITEMS.get()).contains(itemID.toString());
            if (isPotion || isAlcohol || isConfigured) {
                ModEffectEvents.triggerReaction(event.getEntity());
            }
        } else {
            boolean isCoprine = consumedItem.m_204117_(FungiDelightTags.ALCOHOL_REACTION);
            if (isCoprine) {
                event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ModEffects.WEAK_STOMACH.get(), 1200, 0));
            }
        }
    }

    private static void triggerReaction(LivingEntity entity) {
        if (!((Boolean)Configuration.ENABLE_WEAK_STOMACH_EFFECT.get()).booleanValue()) {
            return;
        }
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 1));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 1));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 1));
    }
}

