/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.fungidelight.common.event;

import net.mehdinoui.fungidelight.Configuration;
import net.mehdinoui.fungidelight.common.entity.ai.pig.TruffleDiggingGoal;
import net.mehdinoui.fungidelight.common.entity.ai.wolf.DogTruffleHuntGoal;
import net.mehdinoui.fungidelight.common.registry.ModSoundEvents;
import net.mehdinoui.fungidelight.common.tag.FungiDelightTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fungidelight")
public class ModEntitiesEvents {
    public static final String HUNTING_TAG = "fungidelight.dog_hunting_timer";
    public static final int HUNT_DURATION = 2400;

    @SubscribeEvent
    public static void onDogInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack;
        Wolf wolf;
        if (!((Boolean)Configuration.ENABLE_WOLF_HUNT_TRUFFLE.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof Wolf && (wolf = (Wolf)entity).m_21824_() && (itemStack = event.getItemStack()).m_204117_(FungiDelightTags.TRUFFLES)) {
            if (!event.getLevel().f_46443_) {
                long endTime = event.getLevel().m_46467_() + 2400L;
                wolf.getPersistentData().m_128356_(HUNTING_TAG, endTime);
                wolf.m_216990_((SoundEvent)ModSoundEvents.DOG_SNIFF_TRUFFLE.get());
            }
            if (event.getLevel().f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = event.getLevel().f_46441_.m_188583_() * 0.02;
                    double d1 = event.getLevel().f_46441_.m_188583_() * 0.02;
                    double d2 = event.getLevel().f_46441_.m_188583_() * 0.02;
                    event.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123748_, wolf.m_20208_(1.0), wolf.m_20187_() + 0.5, wolf.m_20262_(1.0), d0, d1, d2);
                }
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPigInteract(PlayerInteractEvent.EntityInteract event) {
        Pig pig;
        if (!((Boolean)Configuration.ENABLE_PIG_FOODS.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)Configuration.ENABLE_PIG_EXTRA_BABY.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof Pig && (pig = (Pig)entity).m_6898_(event.getItemStack()) && event.getItemStack().m_204117_(FungiDelightTags.TRUFFLES) && pig.m_146764_() == 0 && !pig.m_27593_()) {
            pig.getPersistentData().m_128379_("FD_TruffleBred", true);
            if (!event.getLevel().f_46443_) {
                pig.m_27595_(event.getEntity());
                if (!event.getEntity().m_150110_().f_35937_) {
                    event.getItemStack().m_41774_(1);
                }
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBabySpawn(BabyEntitySpawnEvent event) {
        Pig parentA;
        Mob mob;
        Level level;
        block13: {
            block12: {
                if (!((Boolean)Configuration.ENABLE_PIG_FOODS.get()).booleanValue()) {
                    return;
                }
                if (!((Boolean)Configuration.ENABLE_PIG_EXTRA_BABY.get()).booleanValue()) {
                    return;
                }
                level = event.getParentA().m_9236_();
                mob = event.getParentA();
                if (!(mob instanceof Pig)) break block12;
                parentA = (Pig)mob;
                mob = event.getParentB();
                if (mob instanceof Pig) break block13;
            }
            return;
        }
        Pig parentB = (Pig)mob;
        CompoundTag dataA = parentA.getPersistentData();
        CompoundTag dataB = parentB.getPersistentData();
        if (dataA.m_128471_("FD_TruffleBred") || dataB.m_128471_("FD_TruffleBred")) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                float roll = parentA.m_217043_().m_188501_();
                int extrasToSpawn = 0;
                if (roll < 0.1f) {
                    extrasToSpawn = 2;
                } else if (roll < 0.5f) {
                    extrasToSpawn = 1;
                }
                if (extrasToSpawn > 0) {
                    for (int i = 0; i < extrasToSpawn; ++i) {
                        Pig extraBaby = parentA.m_142606_(serverLevel, (AgeableMob)parentB);
                        if (extraBaby == null) continue;
                        extraBaby.m_6863_(true);
                        extraBaby.m_7678_(parentA.m_20185_(), parentA.m_20186_(), parentA.m_20189_(), 0.0f, 0.0f);
                        serverLevel.m_7967_((Entity)extraBaby);
                    }
                }
            }
            dataA.m_128473_("FD_TruffleBred");
            dataB.m_128473_("FD_TruffleBred");
        }
    }

    @SubscribeEvent
    public static void addCustomGoals(EntityJoinLevelEvent event) {
        Entity entity;
        if (((Boolean)Configuration.ENABLE_PIG_DIGGING.get()).booleanValue() && (entity = event.getEntity()) instanceof Pig) {
            Pig pig = (Pig)entity;
            if (pig.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof TruffleDiggingGoal)) {
                return;
            }
            pig.f_21345_.m_25352_(5, (Goal)new TruffleDiggingGoal(pig));
        }
        if (((Boolean)Configuration.ENABLE_WOLF_HUNT_TRUFFLE.get()).booleanValue() && (entity = event.getEntity()) instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            if (wolf.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof DogTruffleHuntGoal)) {
                return;
            }
            wolf.f_21345_.m_25352_(6, (Goal)new DogTruffleHuntGoal(wolf));
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        Wolf wolf;
        LivingEntity livingEntity;
        if (((Boolean)Configuration.ENABLE_WOLF_HUNT_TRUFFLE.get()).booleanValue() && !event.getEntity().m_9236_().f_46443_ && (livingEntity = event.getEntity()) instanceof Wolf && (wolf = (Wolf)livingEntity).getPersistentData().m_128441_(HUNTING_TAG)) {
            long endTime = wolf.getPersistentData().m_128454_(HUNTING_TAG);
            if (wolf.m_9236_().m_46467_() < endTime) {
                ServerLevel serverLevel = (ServerLevel)wolf.m_9236_();
                if (wolf.f_19797_ % 4 == 0) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123757_, wolf.m_20185_(), wolf.m_20186_() + 0.5, wolf.m_20189_(), 3, 0.3, 0.3, 0.3, 0.05);
                }
            }
        }
    }
}

