/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.fungidelight.common.world;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.mehdinoui.fungidelight.Configuration;
import net.mehdinoui.fungidelight.common.registry.ModPlacementModifiers;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.jetbrains.annotations.NotNull;

public class ConfigurableRarityFilter
extends PlacementFilter {
    public static final MapCodec<ConfigurableRarityFilter> CODEC = Codec.STRING.fieldOf("config_key").xmap(ConfigurableRarityFilter::new, ConfigurableRarityFilter::getConfigKey);
    private final String configKey;

    public ConfigurableRarityFilter(String configKey) {
        this.configKey = configKey;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    protected boolean m_213917_(@NotNull PlacementContext ctx, @NotNull RandomSource random, @NotNull BlockPos pos) {
        int chance = this.getConfigValue(this.configKey);
        if (chance == 0) {
            return false;
        }
        if (chance == 1) {
            return true;
        }
        return random.m_188503_(chance) == 0;
    }

    private int getConfigValue(String key) {
        return switch (key) {
            case "huge_inky_cap" -> (Integer)Configuration.CHANCE_HUGE_INKY_CAP.get();
            case "huge_morel" -> (Integer)Configuration.CHANCE_HUGE_MOREL.get();
            case "inky_cap_normal" -> (Integer)Configuration.CHANCE_INKY_CAP_NORMAL.get();
            case "morel_normal" -> (Integer)Configuration.CHANCE_MOREL_NORMAL.get();
            case "inky_cap_common" -> (Integer)Configuration.CHANCE_INKY_CAP_COMMON.get();
            case "morel_common" -> (Integer)Configuration.CHANCE_MOREL_COMMON.get();
            case "inky_cap_rare" -> (Integer)Configuration.CHANCE_INKY_CAP_RARE.get();
            case "morel_rare" -> (Integer)Configuration.CHANCE_MOREL_RARE.get();
            case "inky_cap_colony" -> (Integer)Configuration.CHANCE_INKY_CAP_COLONY.get();
            case "morel_colony" -> (Integer)Configuration.CHANCE_MOREL_COLONY.get();
            case "rooted_dirt_blob" -> (Integer)Configuration.CHANCE_ROOTED_DIRT_BLOB.get();
            case "truffle_dirt_ore" -> (Integer)Configuration.CHANCE_TRUFFLE_DIRT_ORE.get();
            default -> 0;
        };
    }

    @NotNull
    public PlacementModifierType<?> m_183327_() {
        return ModPlacementModifiers.CONFIGURABLE_RARITY_FILTER.get();
    }
}

