/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.fungidelight.common.world.feature;

import com.mojang.serialization.Codec;
import net.mehdinoui.fungidelight.common.block.mushrooms.InkyGooVeilBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import vectorwing.farmersdelight.common.tag.ModTags;

public abstract class CustomHugeMushroomFeature
extends Feature<NoneFeatureConfiguration> {
    protected CustomHugeMushroomFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    protected boolean placeStem(LevelAccessor world, BlockPos pos, int minHeight, int maxHeight, BlockState stemBlock) {
        int stemHeight = minHeight + world.m_213780_().m_188503_(maxHeight - minHeight + 1);
        for (int y = 0; y < stemHeight; ++y) {
            BlockPos stemPos = pos.m_6630_(y);
            if (!world.m_8055_(stemPos).m_247087_()) continue;
            world.m_7731_(stemPos, stemBlock, 3);
        }
        return stemHeight > 0;
    }

    protected void placeCapLayer(LevelAccessor world, BlockPos center, int[][] offsets, BlockState block, boolean hanging) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (int[] offset : offsets) {
            minX = Math.min(minX, offset[0]);
            maxX = Math.max(maxX, offset[0]);
            minZ = Math.min(minZ, offset[1]);
            maxZ = Math.max(maxZ, offset[1]);
        }
        int centerX = (minX + maxX) / 2;
        int centerZ = (minZ + maxZ) / 2;
        if (!hanging) {
            for (int[] offset : offsets) {
                BlockPos blockPos = center.m_7918_(offset[0] - centerX, 0, offset[1] - centerZ);
                if (!world.m_8055_(blockPos).m_247087_()) continue;
                world.m_7731_(blockPos, block, 3);
            }
        } else {
            RandomSource random = world.m_213780_();
            block2: for (int[] offset : offsets) {
                BlockPos blockPos = center.m_7918_(offset[0] - centerX, 0, offset[1] - centerZ);
                if (!world.m_8055_(blockPos).m_247087_() || !(random.m_188501_() < 0.6f)) continue;
                int length = 1 + random.m_188503_(2);
                for (int i = 0; i < length; ++i) {
                    BlockPos hangingPos = blockPos.m_6625_(i);
                    boolean connected = length - i > 1;
                    BlockState finalState = (BlockState)block.m_61124_((Property)InkyGooVeilBlock.CONNECTED, (Comparable)Boolean.valueOf(connected));
                    if (!world.m_8055_(hangingPos).m_247087_()) continue block2;
                    world.m_7731_(hangingPos, finalState, 3);
                }
            }
        }
    }

    protected boolean isValidSpace(LevelAccessor world, BlockPos pos, int mushroomHeight, int capHeight, int mushroomRadius) {
        int y;
        BlockState state = world.m_8055_(pos.m_7495_());
        if (!state.m_204336_(BlockTags.f_144274_) || state.m_204336_(ModTags.MUSHROOM_COLONY_GROWABLE_ON)) {
            return false;
        }
        if (pos.m_123342_() + mushroomHeight >= world.m_151558_()) {
            return false;
        }
        for (y = 0; y <= mushroomHeight; ++y) {
            if (world.m_8055_(pos.m_6630_(y)).m_247087_()) continue;
            return false;
        }
        for (y = mushroomHeight; y >= capHeight; --y) {
            for (int x = -mushroomRadius; x <= mushroomRadius; ++x) {
                for (int z = -mushroomRadius; z <= mushroomRadius; ++z) {
                    if (world.m_8055_(pos.m_7918_(x, y, z)).m_247087_()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

