/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.fungidelight.data;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.mehdinoui.fungidelight.data.ModBlockStateProvider;
import net.mehdinoui.fungidelight.data.ModItemModelProvider;
import net.mehdinoui.fungidelight.data.ModLootTableProvider;
import net.mehdinoui.fungidelight.data.ModWorldGenProvider;
import net.mehdinoui.fungidelight.data.recipe.ModBasicRecipes;
import net.mehdinoui.fungidelight.data.recipe.ModCookingRecipes;
import net.mehdinoui.fungidelight.data.recipe.ModCuttingRecipes;
import net.mehdinoui.fungidelight.data.recipe.ModSmeltingRecipes;
import net.mehdinoui.fungidelight.data.tag.BiomeTags;
import net.mehdinoui.fungidelight.data.tag.BlockTags;
import net.mehdinoui.fungidelight.data.tag.ItemTags;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fungidelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        BlockTags blockTags = new BlockTags(packOutput, lookupProvider, existingFileHelper);
        ItemTags itemTags = new ItemTags(packOutput, lookupProvider, blockTags.m_274426_(), existingFileHelper);
        BiomeTags biomeTags = new BiomeTags(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeServer(), (DataProvider)biomeTags);
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(packOutput){

            protected void m_245200_(Consumer<FinishedRecipe> consumer) {
                ModBasicRecipes.register(consumer);
                ModCookingRecipes.register(consumer);
                ModCuttingRecipes.register(consumer);
                ModSmeltingRecipes.register(consumer);
            }
        });
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGenProvider(packOutput, lookupProvider));
    }
}

