/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.fungidelight.data;

import net.mehdinoui.fungidelight.common.registry.ModBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "fungidelight", exFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("fungidelight", "block/" + path);
    }

    protected void registerStatesAndModels() {
        this.simpleCrossBlock(ModBlocks.INKY_CAP_MUSHROOM);
        this.simpleCrossBlock(ModBlocks.MOREL_MUSHROOM);
        this.stageBlock((Block)ModBlocks.INKY_CAP_MUSHROOM_COLONY.get(), MushroomColonyBlock.COLONY_AGE, new Property[0]);
        this.stageBlock((Block)ModBlocks.MOREL_MUSHROOM_COLONY.get(), MushroomColonyBlock.COLONY_AGE, new Property[0]);
        this.simpleCubeAllBlock(ModBlocks.TRUFFLE_DIRT);
    }

    private void simpleCubeAllBlock(RegistryObject<? extends Block> blockRegistry) {
        Block block = (Block)blockRegistry.get();
        this.simpleBlock(block, (ModelFile)this.models().cubeAll(this.blockName(block), this.resourceBlock(this.blockName(block))));
    }

    private void simpleCrossBlock(RegistryObject<? extends Block> blockRegistry) {
        this.simpleCrossBlock(blockRegistry, false);
    }

    private void simpleCrossBlock(RegistryObject<? extends Block> blockRegistry, boolean isBushCrop) {
        Block block = (Block)blockRegistry.get();
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block)))).renderType("cutout"));
    }

    public void stageBlock(Block block, IntegerProperty ageProperty, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage" + ageSuffix;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }
}

