/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.shulkertooltip;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="shulkertooltip")
public class ShulkerToolTip {
    public static final String MODID = "shulkertooltip";
    private static final KeyMapping enableView = new KeyMapping("key.enableView", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 342, "key.categories.shulkerTooltip");
    private static final KeyMapping openShulker = new KeyMapping("key.openShulker", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 78, "key.categories.shulkerTooltip");
    private static final KeyMapping toggleView = new KeyMapping("key.toggleView", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 86, "key.categories.shulkerTooltip");
    private static final ResourceLocation TEXTURE = new ResourceLocation("shulkertooltip", "textures/gui/shulker_parts.png");

    public ShulkerToolTip() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventManager());
    }

    private class EventManager
    extends GuiGraphics {
        private boolean box;
        private final List<String> ironChestWidths;
        private final String[] boxNames;
        private final int[] boxWidths;
        private float[] color;
        private boolean show;
        private boolean pressed;

        public EventManager() {
            super(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
            this.box = false;
            this.ironChestWidths = Arrays.asList("diamond", "crystal", "obsidian");
            this.boxNames = new String[]{"shulker_box", "end_troll_box", "sack"};
            this.boxWidths = new int[]{8, 8, 8};
            this.show = false;
            this.pressed = false;
        }

        private String shulkerStorageItem(ItemStack stack) {
            String name = stack.m_41720_().m_204114_().m_205785_().m_135782_().toString();
            if (stack.m_41782_()) {
                for (String n : this.boxNames) {
                    if (!name.contains(n)) continue;
                    return name;
                }
            }
            return null;
        }

        @SubscribeEvent
        public void registerKeyMappings(RegisterKeyMappingsEvent e) {
            e.register(enableView);
            e.register(openShulker);
            e.register(toggleView);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void tooltipEvent(ItemTooltipEvent e) {
            if (this.shulkerStorageItem(e.getItemStack()) != null && (enableView.getKey().m_84873_() == -1 || enableView.getKey().m_84873_() != -1 && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)enableView.getKey().m_84873_()) == this.show && this.box)) {
                e.getToolTip().clear();
                e.getToolTip().add(Component.m_237119_());
            }
        }

        @SubscribeEvent
        public void onClick(ScreenEvent.MouseButtonPressed e) {
            if (e.getScreen() instanceof FakeShulkerBox) {
                e.setCanceled(true);
            }
        }

        void boxPart(int atX, int atY, int fromX, int fromY, int toX, int toY) {
            if (this.color != null) {
                RenderSystem.setShaderColor((float)(this.color[0] + 0.15f), (float)(this.color[1] + 0.15f), (float)(this.color[2] + 0.15f), (float)1.0f);
            }
            this.m_280218_(TEXTURE, atX, atY, fromX, fromY, toX, toY);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        private void drawBar(int x, int y, int yStart, int boxWidth, int howTall) {
            this.boxPart(x, y, 0, yStart, 5, howTall);
            for (int i = 0; i < boxWidth + 1; ++i) {
                this.boxPart(x + 4 + i * 18, y, 4, yStart, 18, howTall);
            }
            this.boxPart(x + 4 + (boxWidth + 1) * 18, y, 22, yStart, 6, howTall);
        }

        private int getWidth(String id) {
            for (int i = 0; i < this.boxWidths.length; ++i) {
                if (!id.contains(this.boxNames[i])) continue;
                return this.boxWidths[i];
            }
            return 8;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @SubscribeEvent
        public void event(ScreenEvent.Render.Post event) {
            ItemStack item;
            Minecraft mc = Minecraft.m_91087_();
            long window = mc.m_91268_().m_85439_();
            LocalPlayer p = mc.f_91074_;
            if (event.getScreen() instanceof AbstractContainerScreen) {
                Slot itemSlot = ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse();
                if (itemSlot == null) {
                    return;
                }
                ItemStack itemStack = itemSlot.m_7993_();
                item = itemStack;
            } else {
                if (!(event.getScreen() instanceof ChatScreen)) return;
                Style style = mc.f_91065_.m_93076_().m_93800_((double)event.getMouseX(), (double)event.getMouseY());
                if (style == null) return;
                if (style.m_131186_() == null) return;
                DyeColor[] itemstackinfo = (DyeColor[])style.m_131186_().m_130823_(HoverEvent.Action.f_130832_);
                if (itemstackinfo == null) {
                    return;
                }
                ItemStack itemStack = itemstackinfo.m_130898_();
                item = itemStack;
            }
            if (item == null) {
                return;
            }
            String name = this.shulkerStorageItem(item);
            if (name != null) {
                String id;
                if (toggleView.getKey().m_84873_() != -1 && InputConstants.m_84830_((long)window, (int)toggleView.getKey().m_84873_())) {
                    if (!this.pressed) {
                        this.show = !this.show;
                        this.pressed = true;
                    }
                } else {
                    this.pressed = false;
                }
                for (DyeColor c : DyeColor.values()) {
                    if (name.contains(c.toString().toLowerCase().replace("_", ""))) {
                        this.color = c.m_41068_();
                        break;
                    }
                    this.color = null;
                }
                int boxWidth = this.ironChestWidths.contains((id = item.m_41720_().m_204114_().m_205785_().m_135782_().toString().split(":")[1]).split("_")[0]) ? 11 : this.getWidth(id);
                ListTag nbttaglist = (item.m_41782_() ? item.m_41783_() : new CompoundTag()).m_128469_("BlockEntityTag").m_128437_("Items", 10);
                int slot = 0;
                ArrayList<ItemStack> boxContents = new ArrayList<ItemStack>();
                for (int i = 0; i < nbttaglist.size(); ++i) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)nbttaglist.get(i)));
                    String stringofitems = nbttaglist.get(i).toString();
                    int slotnum = Integer.parseInt(stringofitems.split("Slot:")[1].split("b,")[0].replaceAll("[^0-9]", ""));
                    while (slot != slotnum) {
                        ++slot;
                        boxContents.add(ItemStack.f_41583_);
                    }
                    ++slot;
                    boxContents.add(stack);
                }
                slot %= boxWidth + 1;
                while (boxWidth + 1 > slot && slot != 0) {
                    ++slot;
                    boxContents.add(ItemStack.f_41583_);
                }
                if (openShulker.getKey().m_84873_() != -1 && InputConstants.m_84830_((long)window, (int)openShulker.getKey().m_84873_())) {
                    if (boxWidth != 8 || boxContents.size() > 54) {
                        p.m_213846_((Component)Component.m_237113_((String)"\u00a7cERROR: Chest contents wouldn't fit in GUI."));
                    }
                    SimpleContainer inventory = new SimpleContainer(boxContents.size() < 27 ? 27 : boxContents.size());
                    for (int i = 0; i < boxContents.size(); ++i) {
                        inventory.m_6836_(i, (ItemStack)boxContents.get(i));
                    }
                    ChestMenu container = new ChestMenu(MenuType.f_39959_, p.f_36096_.f_38840_, p.m_150109_(), (Container)inventory, 3);
                    mc.m_91152_((Screen)new FakeShulkerBox(container, p.m_150109_(), item.m_41611_()));
                }
                if (enableView.getKey().m_84873_() == -1 || enableView.getKey().m_84873_() != -1 && InputConstants.m_84830_((long)window, (int)enableView.getKey().m_84873_()) == this.show) {
                    int lengthOver = event.getMouseX() + 32 + boxWidth * 18 - mc.m_91268_().m_85441_();
                    int toolTipHeight = 8 + (boxContents.size() - 1) / boxWidth * 18;
                    int centerToolTip = toolTipHeight / 2;
                    int lengthAbove = event.getMouseY() - 23 - centerToolTip;
                    int lengthBelow = event.getMouseY() - 10 + toolTipHeight - mc.m_91268_().m_85442_() - centerToolTip;
                    this.box = true;
                    int drawX = event.getMouseX() + 4 - (lengthOver > 0 ? lengthOver : 0);
                    int drawY = event.getMouseY() - 12 - centerToolTip - (lengthBelow > 0 ? lengthBelow : 0) - (lengthAbove < 0 ? lengthAbove : 0);
                    RenderSystem.disableDepthTest();
                    this.m_280168_().m_252880_(0.0f, 0.0f, 777.0f);
                    this.drawBar(drawX, drawY - 11, 0, boxWidth, 16);
                    this.m_280168_().m_252880_(0.0f, 0.0f, 777.0f);
                    this.m_280488_(mc.f_91062_, item.m_41611_().getString().replace("[", "").replace("]", ""), drawX + 6, drawY - 6, 0xFFFFFF);
                    int row = 0;
                    slot = 0;
                    int x = 0;
                    int y = drawY + 6 + 18 * row;
                    this.boxPart(drawX, drawY + 5, 0, 4, 5, 18);
                    this.boxPart(drawX + (boxWidth + 1) * 18 + 5, drawY + 5, 23, 5, 5, 18);
                    for (int i = 0; i < boxContents.size(); ++i) {
                        if (slot > boxWidth) {
                            slot = 0;
                            this.boxPart(drawX, drawY + 5 + 18 * ++row, 0, 4, 5, 18);
                            this.boxPart(drawX + (boxWidth + 1) * 18 + 5, drawY + 5 + 18 * row, 23, 5, 5, 18);
                        }
                        x = drawX + 6 + 18 * slot;
                        y = drawY + 6 + 18 * row;
                        this.boxPart(x - 1, y - 1, 5, 17, 18, 18);
                        this.m_280480_((ItemStack)boxContents.get(i), x, y);
                        this.m_280370_(mc.f_91062_, (ItemStack)boxContents.get(i), x, y);
                        ++slot;
                    }
                    while (boxWidth + 1 > slot) {
                        x = drawX + 6 + 18 * slot;
                        this.boxPart(x - 1, y - 1, 5, 17, 18, 18);
                        ++slot;
                    }
                    this.drawBar(drawX, drawY + (row + 1) * 18 + 5, 35, boxWidth, 5);
                    this.m_280168_().m_252880_(0.0f, 0.0f, -777.0f);
                    this.m_280168_().m_252880_(0.0f, 0.0f, -777.0f);
                }
                RenderSystem.enableDepthTest();
                return;
            } else {
                this.box = false;
            }
        }
    }

    private class FakeShulkerBox
    extends ContainerScreen {
        public FakeShulkerBox(ChestMenu container, Inventory inventory, Component name) {
            super(container, inventory, name);
        }
    }
}

