/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.networking.BaseAccessoriesPacket;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

public record SyncEntireContainer(int entityId, NbtMapCarrier containerMap) implements BaseAccessoriesPacket
{
    public static final Endec<SyncEntireContainer> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", SyncEntireContainer::entityId), (StructField)NbtMapCarrier.ENDEC.fieldOf("containerTag", SyncEntireContainer::containerMap), SyncEntireContainer::new);
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Player player) {
        Level level = player.m_9236_();
        Entity entity = level.m_6815_(this.entityId);
        if (entity == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as it is null on the Client! [EntityId: {}]", (Object)this.entityId);
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AccessoriesCapability capability = AccessoriesCapability.get(livingEntity);
        if (capability == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as its Capability is null on the Client! [EntityId: {}]", (Object)this.entityId);
            return;
        }
        AccessoriesHolderImpl holder = (AccessoriesHolderImpl)capability.getHolder();
        holder.read(this.containerMap, SerializationContext.empty());
        holder.init(capability);
    }
}

