/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.LampConnectorBlock;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.registry.AFBlocks;
import com.starfish_studios.another_furniture.registry.AFItemTags;
import com.starfish_studios.another_furniture.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LampBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final int LEVEL_MIN = 1;
    protected static final int LEVEL_MAX = 3;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = ModBlockStateProperties.FACING_EXCEPT_DOWN;
    public static final IntegerProperty LEVEL = ModBlockStateProperties.LEVEL_1_3;
    public static final BooleanProperty BASE = ModBlockStateProperties.BASE;
    protected static final VoxelShape AABB_UP = Block.m_49796_((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape AABB_UP_NORMAL = Shapes.m_83110_((VoxelShape)AABB_UP, (VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0));
    protected static final VoxelShape AABB_UP_TOP = Shapes.m_83110_((VoxelShape)AABB_UP, (VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0));
    protected static final VoxelShape AABB_NORTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.0, (double)8.0, (double)5.0, (double)13.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.0, (double)0.0, (double)14.0, (double)11.0, (double)6.0, (double)16.0), Block.m_49796_((double)7.0, (double)2.0, (double)9.0, (double)9.0, (double)8.0, (double)11.0), Block.m_49796_((double)7.0, (double)2.0, (double)11.0, (double)9.0, (double)4.0, (double)14.0)});
    protected static final VoxelShape AABB_EAST = ShapeUtil.rotateShape(AABB_NORTH, Direction.EAST);
    protected static final VoxelShape AABB_SOUTH = ShapeUtil.rotateShape(AABB_NORTH, Direction.SOUTH);
    protected static final VoxelShape AABB_WEST = ShapeUtil.rotateShape(AABB_NORTH, Direction.WEST);
    private final DyeColor color;

    public LampBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(3))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BASE, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> AABB_NORTH;
            case Direction.EAST -> AABB_EAST;
            case Direction.SOUTH -> AABB_SOUTH;
            case Direction.WEST -> AABB_WEST;
            default -> (Boolean)state.m_61143_((Property)BASE) != false ? AABB_UP_NORMAL : AABB_UP_TOP;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        BlockState blockstate = this.m_49966_();
        if (level.m_276867_(pos)) {
            blockstate = (BlockState)blockstate.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return clickedFace != Direction.DOWN ? (BlockState)((BlockState)blockstate.m_61124_((Property)FACING, (Comparable)clickedFace)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)) : null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (state.m_61143_((Property)FACING) == Direction.UP && (direction == Direction.UP || direction == Direction.DOWN)) {
            LampConnectorBlock connectorBlock;
            LampBlock lampBlock;
            boolean bConnect;
            LampConnectorBlock connectorBlock2;
            LampBlock lampBlock2;
            BlockState aState = level.m_8055_(currentPos.m_7494_());
            BlockState bState = level.m_8055_(currentPos.m_7495_());
            Block block = aState.m_60734_();
            boolean aConnect = block instanceof LampBlock && (lampBlock2 = (LampBlock)block).getColor() == this.getColor() && aState.m_61143_((Property)FACING) == Direction.UP || (block = aState.m_60734_()) instanceof LampConnectorBlock && (connectorBlock2 = (LampConnectorBlock)block).getColor() == this.getColor();
            Block block2 = bState.m_60734_();
            boolean bl = bConnect = block2 instanceof LampBlock && (lampBlock = (LampBlock)block2).getColor() == this.getColor() && bState.m_61143_((Property)FACING) == Direction.UP || (block2 = bState.m_60734_()) instanceof LampConnectorBlock && (connectorBlock = (LampConnectorBlock)block2).getColor() == this.getColor();
            state = aConnect && !bConnect ? (BlockState)((BlockState)LampBlock.getLampConnectorByColor(this.color).m_49966_().m_61124_((Property)BASE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED))) : (!aConnect && bConnect ? (BlockState)state.m_61124_((Property)BASE, (Comparable)Boolean.valueOf(false)) : (aConnect ? (BlockState)((BlockState)LampBlock.getLampConnectorByColor(this.color).m_49966_().m_61124_((Property)BASE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED))) : (BlockState)state.m_61124_((Property)BASE, (Comparable)Boolean.valueOf(true))));
        }
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos facingPos = pos.m_121945_(direction.m_122424_());
        BlockState facingState = level.m_8055_(facingPos);
        return direction == Direction.UP || facingState.m_60783_((BlockGetter)level, facingPos, direction);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        if (level.f_46443_) {
            return;
        }
        BlockState below = level.m_8055_(pos.m_7495_());
        boolean bl = powered = level.m_276867_(pos) || below.m_60734_() instanceof LampConnectorBlock && (Boolean)below.m_61143_((Property)POWERED) != false;
        if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
            if ((Boolean)state.m_61143_((Property)LIT) != powered) {
                state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(powered));
                level.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
        }
        level.m_7731_(pos, state, 3);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_204117_(AFItemTags.LAMPS) && state.m_61143_((Property)FACING) == Direction.UP && hit.m_82434_() == Direction.UP) {
            return InteractionResult.FAIL;
        }
        if (player.m_6047_()) {
            int light = (Integer)state.m_61143_((Property)LEVEL);
            light = light >= 3 ? 1 : light + 1;
            state = (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(light));
        } else {
            state = (BlockState)state.m_61122_((Property)LIT);
        }
        level.m_7731_(pos, state, 3);
        level.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, LIT, POWERED, FACING, LEVEL, BASE});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static Block getLampConnectorByColor(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> AFBlocks.WHITE_LAMP_CONNECTOR.get();
            case DyeColor.ORANGE -> AFBlocks.ORANGE_LAMP_CONNECTOR.get();
            case DyeColor.MAGENTA -> AFBlocks.MAGENTA_LAMP_CONNECTOR.get();
            case DyeColor.LIGHT_BLUE -> AFBlocks.LIGHT_BLUE_LAMP_CONNECTOR.get();
            case DyeColor.YELLOW -> AFBlocks.YELLOW_LAMP_CONNECTOR.get();
            case DyeColor.LIME -> AFBlocks.LIME_LAMP_CONNECTOR.get();
            case DyeColor.PINK -> AFBlocks.PINK_LAMP_CONNECTOR.get();
            case DyeColor.GRAY -> AFBlocks.GRAY_LAMP_CONNECTOR.get();
            case DyeColor.LIGHT_GRAY -> AFBlocks.LIGHT_GRAY_LAMP_CONNECTOR.get();
            case DyeColor.CYAN -> AFBlocks.CYAN_LAMP_CONNECTOR.get();
            case DyeColor.PURPLE -> AFBlocks.PURPLE_LAMP_CONNECTOR.get();
            case DyeColor.BLUE -> AFBlocks.BLUE_LAMP_CONNECTOR.get();
            case DyeColor.BROWN -> AFBlocks.BROWN_LAMP_CONNECTOR.get();
            case DyeColor.GREEN -> AFBlocks.GREEN_LAMP_CONNECTOR.get();
            case DyeColor.RED -> AFBlocks.RED_LAMP_CONNECTOR.get();
            case DyeColor.BLACK -> AFBlocks.BLACK_LAMP_CONNECTOR.get();
        };
    }
}

