/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.cannon.twin_autocannon;

import com.dsvv.cbcat.cannon.twin_autocannon.TwinAutocannonBlockEntity;
import com.dsvv.cbcat.cannon.twin_autocannon.breech.TwinAutocannonBreechBlock;
import com.dsvv.cbcat.cannon.twin_autocannon.breech.TwinAutocannonInventoryHandler;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandler;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.AnimatedAutocannon;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerItem;

public class TwinAutocannonBreechBlockEntity
extends TwinAutocannonBlockEntity
implements AnimatedAutocannon {
    protected static final int[] FIRE_RATES = new int[]{60, 40, 30, 24, 20, 15, 12, 10, 8, 6, 5, 4, 3, 3, 2};
    private int fireRate = 7;
    private int firingCooldown;
    private int animateTicks = 5;
    private boolean updateInstance = true;
    @Nullable
    DyeColor seat = null;
    private IItemHandler inventory;
    private final Deque<ItemStack> inputBuffer = new LinkedList<ItemStack>();
    private ItemStack outputBuffer = ItemStack.f_41583_;
    private ItemStack magazine = ItemStack.f_41583_;

    public TwinAutocannonBreechBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public int getQueueLimit() {
        return 5;
    }

    public Deque<ItemStack> getInputBuffer() {
        return this.inputBuffer;
    }

    public ItemStack getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setOutputBuffer(ItemStack stack) {
        this.outputBuffer = stack;
    }

    public void setMagazine(ItemStack stack) {
        this.magazine = stack;
        this.updateInstance = true;
    }

    public ItemStack getMagazine() {
        return this.magazine;
    }

    public void tick() {
        super.tick();
        this.allTick(this.m_58904_());
    }

    @Override
    public void tickFromContraption(Level level, PitchOrientedContraptionEntity poce, BlockPos localPos) {
        super.tickFromContraption(level, poce, localPos);
        this.allTick(level);
        if (!level.f_46443_ && this.updateInstance) {
            this.updateInstance = false;
            Contraption contraption = poce.getContraption();
            BigCannonBlock.writeAndSyncSingleBlockData((BlockEntity)this, (StructureTemplate.StructureBlockInfo)((StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localPos)), (AbstractContraptionEntity)poce, (Contraption)contraption);
        }
    }

    private void allTick(Level level) {
        if (this.fireRate < 0 || this.fireRate > 15) {
            this.fireRate = 0;
        }
        if (this.firingCooldown < 0) {
            this.firingCooldown = 0;
        }
        if (this.firingCooldown > 0) {
            --this.firingCooldown;
        }
        if (this.animateTicks < 5) {
            ++this.animateTicks;
        }
        if (this.animateTicks < 0) {
            this.animateTicks = 0;
        }
    }

    public void setFireRate(int power) {
        this.fireRate = Mth.m_14045_((int)power, (int)0, (int)15);
    }

    public int getFireRate() {
        return this.fireRate;
    }

    public int getActualFireRate() {
        if (this.fireRate < 1 || this.fireRate > 15) {
            return 0;
        }
        int cooldown = FIRE_RATES[this.fireRate - 1];
        return 1200 / cooldown;
    }

    public boolean canFire() {
        return this.getFireRate() > 0 && this.firingCooldown <= 0;
    }

    public void handleFiring() {
        if (this.fireRate > 0 && this.fireRate <= FIRE_RATES.length) {
            this.firingCooldown = FIRE_RATES[this.fireRate - 1];
            this.animateTicks = 0;
        }
    }

    public float getAnimateOffset(float partialTicks) {
        float t = ((float)this.animateTicks + partialTicks) * 1.2f;
        if (t <= 0.0f || t >= 4.8f) {
            return 0.0f;
        }
        float f = t < 1.0f ? t : (4.8f - t) / 3.8f;
        return Mth.m_14031_((float)(f * 1.5707964f));
    }

    public void incrementAnimationTicks() {
        ++this.animateTicks;
    }

    public int getAnimationTicks() {
        return this.animateTicks;
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.m_58900_().m_61124_((Property)TwinAutocannonBreechBlock.HANDLE, (Comparable)Boolean.valueOf(tag.m_128471_("Handle")));
        this.fireRate = tag.m_128451_("FiringRate");
        this.firingCooldown = tag.m_128451_("Cooldown");
        this.animateTicks = tag.m_128451_("AnimateTicks");
        this.outputBuffer = tag.m_128441_("Output") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Output")) : ItemStack.f_41583_;
        this.seat = DyeColor.m_41057_((String)tag.m_128461_("Seat"), null);
        this.inputBuffer.clear();
        ListTag inputTag = tag.m_128437_("Input", 10);
        for (int i = 0; i < inputTag.size(); ++i) {
            this.inputBuffer.add(ItemStack.m_41712_((CompoundTag)inputTag.m_128728_(i)));
        }
        ItemStack itemStack = this.magazine = tag.m_128441_("Magazine") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Magazine")) : ItemStack.f_41583_;
        if (!clientPacket) {
            return;
        }
        this.updateInstance = tag.m_128441_("UpdateInstance");
        if (clientPacket && !this.isVirtual()) {
            this.requestModelDataUpdate();
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128379_("Handle", ((Boolean)this.m_58900_().m_61143_((Property)TwinAutocannonBreechBlock.HANDLE)).booleanValue());
        tag.m_128405_("FiringRate", this.fireRate);
        tag.m_128405_("Cooldown", this.firingCooldown);
        tag.m_128405_("AnimateTicks", this.animateTicks);
        if (this.outputBuffer != null && !this.outputBuffer.m_41619_()) {
            tag.m_128365_("Output", (Tag)this.outputBuffer.m_41739_(new CompoundTag()));
        }
        if (this.seat != null) {
            tag.m_128359_("Seat", this.seat.m_7912_());
        }
        if (!this.inputBuffer.isEmpty()) {
            tag.m_128365_("Input", (Tag)this.inputBuffer.stream().map(s -> s.m_41739_(new CompoundTag())).collect(Collectors.toCollection(ListTag::new)));
        }
        if (this.magazine != null && !this.magazine.m_41619_()) {
            tag.m_128365_("Magazine", (Tag)this.magazine.m_41739_(new CompoundTag()));
        }
        if (!clientPacket) {
            return;
        }
        if (this.updateInstance) {
            tag.m_128379_("UpdateInstance", true);
        }
    }

    public boolean isInputFull() {
        return this.inputBuffer.size() >= this.getQueueLimit() || !this.magazine.m_41619_();
    }

    public boolean isOutputFull() {
        return !this.outputBuffer.m_41619_();
    }

    public ItemStack insertOutput(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (this.isOutputFull()) {
            return stack;
        }
        this.outputBuffer = stack;
        return ItemStack.f_41583_;
    }

    public ItemStack extractNextInput() {
        if (!this.inputBuffer.isEmpty()) {
            return this.inputBuffer.poll();
        }
        if (this.magazine.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int totalCount = AutocannonAmmoContainerItem.getTotalAmmoCount((ItemStack)this.magazine);
        if (totalCount == 0) {
            return ItemStack.f_41583_;
        }
        if (totalCount == 1) {
            this.updateInstance = true;
        }
        return AutocannonAmmoContainerItem.pollItemFromContainer((ItemStack)this.magazine);
    }

    @Override
    public List<ItemStack> getDrops() {
        List list = super.getDrops();
        for (ItemStack s : this.inputBuffer) {
            if (s.m_41619_()) continue;
            list.add(s.m_41777_());
        }
        if (!this.outputBuffer.m_41619_()) {
            list.add(this.outputBuffer.m_41777_());
        }
        if (!this.magazine.m_41619_()) {
            list.add(this.magazine.m_41777_());
        }
        return list;
    }

    protected AABB createRenderBoundingBox() {
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)TwinAutocannonBreechBlock.FACING);
        Direction ammoContainerDir = dir.m_122434_().m_122479_() ? dir.m_175362_(Direction.Axis.Y) : Direction.EAST;
        return super.createRenderBoundingBox().m_82369_(new Vec3(dir.m_122424_().m_253071_()).m_82549_(new Vec3(ammoContainerDir.m_253071_())));
    }

    public void setSeatColor(@Nullable DyeColor color) {
        this.seat = color;
        this.updateInstance = true;
        this.notifyUpdate();
    }

    @Nullable
    public DyeColor getSeatColor() {
        return this.seat;
    }

    public IItemHandler createItemHandler() {
        return this.inventory == null ? (this.inventory = new TwinAutocannonInventoryHandler(this)) : this.inventory;
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
        if (!this.f_58859_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> VisualizationHelper.queueUpdate((BlockEntity)this));
        }
    }
}

