/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.crafting.jei;

import com.dsvv.cbcat.cannon.heavy_autocannon.munitions.AbstractFuzedHeavyAutocannonProjectileItem;
import com.dsvv.cbcat.cannon.heavy_autocannon.munitions.AbstractHeavyAutocannonProjectileItem;
import com.dsvv.cbcat.cannon.heavy_autocannon.munitions.HeavyAutocannonCartridgeItem;
import com.dsvv.cbcat.cartridge.ProjectileCartridge;
import com.dsvv.cbcat.cluster_munition.FuzedClusterProjectileBlockItem;
import com.dsvv.cbcat.registry.BlockRegister;
import com.dsvv.cbcat.registry.ExtraDataRegister;
import com.dsvv.cbcat.registry.ItemRegister;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCItems;

@JeiPlugin
public class CBCATJEI
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = new ResourceLocation("cbc_at", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        super.registerRecipes(registration);
        registration.addRecipes(RecipeTypes.CRAFTING, this.getMunitionAssemblyRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, this.getClusterMunitionAssemblyRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, this.getCaselessMunitionAssemblyRecipes());
    }

    public List<CraftingRecipe> getMunitionAssemblyRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        ArrayList projectileItems = new ArrayList();
        ArrayList powder = new ArrayList();
        ArrayList results = new ArrayList();
        BuiltInRegistries.f_257033_.m_123024_().forEach(i -> {
            if (i instanceof AbstractHeavyAutocannonProjectileItem) {
                projectileItems.add(i);
            } else if (i instanceof HeavyAutocannonCartridgeItem && !i.equals(ItemRegister.HEAVY_AUTOCANNON_EMPTY_CARTRIDGE.get())) {
                results.add(i);
            } else if (i.equals(Items.f_42403_) || i.equals(CBCItems.NITROPOWDER.get())) {
                powder.add(i);
            }
        });
        Ingredient projectiles = Ingredient.m_43929_((ItemLike[])((ItemLike[])projectileItems.toArray(new Item[0])));
        Ingredient propellant = Ingredient.m_43929_((ItemLike[])((ItemLike[])powder.toArray(new Item[0])));
        for (Item result : results) {
            if (!(result instanceof HeavyAutocannonCartridgeItem)) continue;
            HeavyAutocannonCartridgeItem cartridgeItem = (HeavyAutocannonCartridgeItem)result;
            recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("cbc_at", result.toString() + "_recipe"), "", CraftingBookCategory.MISC, cartridgeItem.m_7968_(), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{projectiles, propellant, propellant, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemRegister.HEAVY_AUTOCANNON_EMPTY_CARTRIDGE})})));
        }
        return recipes;
    }

    public List<CraftingRecipe> getClusterMunitionAssemblyRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        ArrayList projectileItems = new ArrayList();
        ArrayList<Item> secondaryProjectileItems = new ArrayList<Item>();
        ArrayList slabItems = new ArrayList();
        ArrayList powder = new ArrayList();
        ArrayList results = new ArrayList();
        BuiltInRegistries.f_257033_.m_123024_().forEach(i -> {
            SlabBlock slabBlock;
            BlockItem blockItem;
            Block patt4880$temp;
            if (i instanceof AbstractFuzedHeavyAutocannonProjectileItem) {
                projectileItems.add(i);
                secondaryProjectileItems.add((Item)i);
            } else if (i instanceof FuzedClusterProjectileBlockItem && !(((BlockItem)i).m_40614_() instanceof ProjectileCartridge)) {
                results.add(i);
            } else if (i.equals(Items.f_42403_)) {
                powder.add(i);
            } else if (i instanceof BlockItem && (patt4880$temp = (blockItem = (BlockItem)i).m_40614_()) instanceof SlabBlock && new ItemStack((ItemLike)(slabBlock = (SlabBlock)patt4880$temp)).m_204117_(ItemTags.f_13175_)) {
                slabItems.add(i);
            }
        });
        secondaryProjectileItems.add(Items.f_41852_);
        Ingredient projectiles = Ingredient.m_43929_((ItemLike[])((ItemLike[])projectileItems.toArray(new Item[0])));
        Ingredient secondaryProjectiles = Ingredient.m_43929_((ItemLike[])((ItemLike[])secondaryProjectileItems.toArray(new Item[0])));
        Ingredient slabs = Ingredient.m_43929_((ItemLike[])((ItemLike[])slabItems.toArray(new Item[0])));
        for (Item result : results) {
            if (!(result instanceof FuzedClusterProjectileBlockItem)) continue;
            FuzedClusterProjectileBlockItem clusterItem = (FuzedClusterProjectileBlockItem)result;
            recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("cbc_at", result + "_recipe"), "", CraftingBookCategory.MISC, clusterItem.m_7968_(), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{projectiles, projectiles, projectiles, projectiles, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42403_}), slabs})));
            recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("cbc_at", result + "_recipe"), "", CraftingBookCategory.MISC, clusterItem.m_7968_(), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{projectiles, projectiles, projectiles, projectiles, secondaryProjectiles, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42403_}), slabs})));
            recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("cbc_at", result + "_recipe"), "", CraftingBookCategory.MISC, clusterItem.m_7968_(), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{projectiles, projectiles, projectiles, projectiles, secondaryProjectiles, secondaryProjectiles, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42403_}), slabs})));
            recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("cbc_at", result + "_recipe"), "", CraftingBookCategory.MISC, clusterItem.m_7968_(), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{projectiles, projectiles, projectiles, projectiles, secondaryProjectiles, secondaryProjectiles, secondaryProjectiles, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42403_}), slabs})));
        }
        return recipes;
    }

    public List<CraftingRecipe> getCaselessMunitionAssemblyRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        ArrayList results = new ArrayList();
        BuiltInRegistries.f_257033_.m_123024_().forEach(i -> {
            BlockItem bItem;
            if (i instanceof BlockItem && (bItem = (BlockItem)i).m_40614_() instanceof ProjectileCartridge && !BlockRegister.GRAPESHOT_CASELESS_BLOCK.is(i) && !BlockRegister.GRAPESHOT_CARTRIDGE_BLOCK.is(i)) {
                results.add(i);
            }
        });
        for (Item result : results) {
            String resultName = ExtraDataRegister.getCartridgeReverse(result);
            if (resultName.contains("caseless")) continue;
            recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("cbc_at", result + "_recipe"), "", CraftingBookCategory.MISC, ExtraDataRegister.getCartridge(resultName).m_5456_().m_7968_(), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{CBCBlocks.POWDER_CHARGE}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ExtraDataRegister.getProjectileReverse(resultName)})})));
            recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("cbc_at", result + "_caseless_recipe"), "", CraftingBookCategory.MISC, ExtraDataRegister.getCartridge(resultName + " caseless").m_5456_().m_7968_(), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{CBCItems.NITROPOWDER}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CBCItems.NITROPOWDER}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{CBCItems.NITROPOWDER}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ExtraDataRegister.getProjectileReverse(resultName)})})));
        }
        return recipes;
    }
}

