/*
 * Decompiled with CFR 0.152.
 */
package com.dsvv.cbcat.registry;

import com.dsvv.cbcat.CreateBigCannons_AdvancedTechnology;
import com.dsvv.cbcat.crafting.CaselessMunitionAssemblyRecipe;
import com.dsvv.cbcat.crafting.ClusterMunitionAssemblyRecipe;
import com.dsvv.cbcat.crafting.HAMunitionAssemblyRecipe;
import com.dsvv.cbcat.crafting.HAMunitionFuzingRecipe;
import com.dsvv.cbcat.crafting.HAMunitionTracerRecipe;
import com.dsvv.cbcat.crafting.HAMunitionTracerRemovalRecipe;
import com.dsvv.cbcat.crafting.HAMunitionUnfuzingRecipe;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;

public enum RecipeRegister implements IRecipeTypeInfo
{
    HA_MUNITION_ASSEMBLY(RecipeRegister.noSerializer(HAMunitionAssemblyRecipe::new)),
    HA_MUNITION_FUZING(RecipeRegister.noSerializer(HAMunitionFuzingRecipe::new)),
    HA_MUNITION_UNFUZING(RecipeRegister.noSerializer(HAMunitionUnfuzingRecipe::new)),
    HA_MUNITION_TRACER(RecipeRegister.noSerializer(HAMunitionTracerRecipe::new)),
    HA_MUNITION_TRACER_REMOVAL(RecipeRegister.noSerializer(HAMunitionTracerRemovalRecipe::new)),
    CLUSTER_MUNITION_ASSEMBLY(RecipeRegister.noSerializer(ClusterMunitionAssemblyRecipe::new)),
    CASELESS_MUNITION_ASSEMBLY(RecipeRegister.noSerializer(CaselessMunitionAssemblyRecipe::new));

    private final ResourceLocation id;
    private final Supplier<RecipeSerializer<?>> serializerObject;
    @Nullable
    private final RecipeType<?> typeObject;
    private final NonNullSupplier<RecipeType<?>> type;

    private RecipeRegister(NonNullSupplier<RecipeSerializer<?>> serializerSupplier, NonNullSupplier<RecipeType<?>> typeSupplier, boolean registerType) {
        String name = CreateLang.asId((String)this.name());
        this.id = new ResourceLocation("cbc_at", name);
        this.serializerObject = IndexPlatform.registerRecipeSerializer((ResourceLocation)this.id, serializerSupplier);
        if (registerType) {
            this.typeObject = (RecipeType)typeSupplier.get();
            IndexPlatform.registerRecipeType((ResourceLocation)this.id, typeSupplier);
            this.type = typeSupplier;
        } else {
            this.typeObject = null;
            this.type = typeSupplier;
        }
    }

    private RecipeRegister(NonNullSupplier<RecipeSerializer<?>> serializerSupplier) {
        String name = CreateLang.asId((String)this.name());
        this.id = CreateBigCannons.resource((String)name);
        this.serializerObject = IndexPlatform.registerRecipeSerializer((ResourceLocation)this.id, serializerSupplier);
        this.typeObject = RecipeRegister.simpleType(this.id);
        this.type = () -> this.typeObject;
        IndexPlatform.registerRecipeType((ResourceLocation)this.id, this.type);
    }

    private RecipeRegister(ProcessingRecipeBuilder.ProcessingRecipeFactory<?> processingFactory) {
        this(() -> new ProcessingRecipeSerializer(processingFactory));
    }

    public static <T extends Recipe<?>> RecipeType<T> simpleType(ResourceLocation id) {
        final String stringId = id.toString();
        return new RecipeType<T>(){

            public String toString() {
                return stringId;
            }
        };
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public <T extends RecipeSerializer<?>> T getSerializer() {
        return (T)this.serializerObject.get();
    }

    public <T extends RecipeType<?>> T getType() {
        return (T)((RecipeType)this.type.get());
    }

    public static void register() {
        CreateBigCannons_AdvancedTechnology.REGISTRATE.addDataGenerator(ProviderType.RECIPE, RecipeRegister::buildRecipe);
    }

    public static void buildRecipe(Consumer<FinishedRecipe> cons) {
        SpecialRecipeBuilder.m_245676_(HA_MUNITION_ASSEMBLY.getSerializer()).m_126359_(cons, "ha_munition_assembly");
        SpecialRecipeBuilder.m_245676_(HA_MUNITION_FUZING.getSerializer()).m_126359_(cons, "ha_munition_fuzing");
        SpecialRecipeBuilder.m_245676_(HA_MUNITION_UNFUZING.getSerializer()).m_126359_(cons, "ha_munition_unfuzing");
        SpecialRecipeBuilder.m_245676_(HA_MUNITION_TRACER.getSerializer()).m_126359_(cons, "ha_munition_tracer");
        SpecialRecipeBuilder.m_245676_(HA_MUNITION_TRACER_REMOVAL.getSerializer()).m_126359_(cons, "ha_munition_tracer_removal");
        SpecialRecipeBuilder.m_245676_(CLUSTER_MUNITION_ASSEMBLY.getSerializer()).m_126359_(cons, "cluster_munition_assembly");
        SpecialRecipeBuilder.m_245676_(CASELESS_MUNITION_ASSEMBLY.getSerializer()).m_126359_(cons, "caseless_munition_assembly");
    }

    private static <T extends Recipe<?>> NonNullSupplier<RecipeSerializer<?>> noSerializer(Function<ResourceLocation, T> prov) {
        return () -> new SimpleRecipeSerializer(prov);
    }

    private static class SimpleRecipeSerializer<T extends Recipe<?>>
    implements RecipeSerializer<T> {
        private final Function<ResourceLocation, T> constructor;

        public SimpleRecipeSerializer(Function<ResourceLocation, T> constructor) {
            this.constructor = constructor;
        }

        public T m_6729_(ResourceLocation recipeId, JsonObject serializedRecipe) {
            return (T)((Recipe)this.constructor.apply(recipeId));
        }

        public T m_8005_(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return (T)((Recipe)this.constructor.apply(recipeId));
        }

        public void m_6178_(FriendlyByteBuf buffer, T recipe) {
        }
    }
}

