/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Set;
import net.felis.cbc_ballistics.block.entity.CalculatorBlockEntity;
import net.felis.cbc_ballistics.block.entity.ModBlockEntities;
import net.felis.cbc_ballistics.networking.ModMessages;
import net.felis.cbc_ballistics.networking.packet.artilleryCoordinator.OpenCoordinatorS2CPacket;
import net.felis.cbc_ballistics.networking.packet.artilleryCoordinator.SyncArtilleryNetS2CPacket;
import net.felis.cbc_ballistics.networking.packet.artilleryCoordinator.UpdateArtilleryNetDataS2CPacket;
import net.felis.cbc_ballistics.networking.packet.artilleryCoordinator.removeNetworkS2CPacket;
import net.felis.cbc_ballistics.screen.Artillery_CoordinatorInterface;
import net.felis.cbc_ballistics.util.ParticleHelper;
import net.felis.cbc_ballistics.util.Utils;
import net.felis.cbc_ballistics.util.artilleryNetwork.Director;
import net.felis.cbc_ballistics.util.artilleryNetwork.Layer;
import net.felis.cbc_ballistics.util.artilleryNetwork.NetworkComponent;
import net.felis.cbc_ballistics.util.calculator.FiringSolutions;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ArtilleryCoordinatorBlockEntity
extends BlockEntity
implements NetworkComponent {
    private static final Component NETWORK = Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.network");
    private static final Component AT = Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.at");
    private static final Component SUB = Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.sub");
    private static final Component SUPER = Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.super");
    private static final Component DIRECTOR_ID = Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.directors.id");
    private static final Component CANNON = Component.m_237115_((String)"block.cbc_ballistics.artillery_coordinator.cannon");
    private static final Component ARROW = Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.arrow");
    private CompoundTag saveData;
    private static final ArrayList<ArtilleryCoordinatorBlockEntity> networks = new ArrayList();
    private final ArrayList<Director> directors = new ArrayList();
    private final ArrayList<Layer> cannons = new ArrayList();
    private String network_id;
    private int prevReady;
    double medianPres = 0.0;
    double medianDisp = 0.0;
    double medianTTT = 0.0;
    private Mode mode;
    private int[] tPos;
    private ArtilleryCoordinatorBlockEntity superior;
    private final ArrayList<ArtilleryCoordinatorBlockEntity> suboridinates = new ArrayList();

    public ArtilleryCoordinatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.ARTILLERY_COORDINATOR_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.mode = Mode.INDIRECT;
    }

    public void removeSubordinate(ArtilleryCoordinatorBlockEntity block) {
        this.suboridinates.remove(block);
        this.m_6596_();
    }

    public ArrayList<ArtilleryCoordinatorBlockEntity> getSuboridinates() {
        return this.suboridinates;
    }

    public void superiorOf(ArtilleryCoordinatorBlockEntity be) {
        be.setSuperior(this);
        if (!this.suboridinates.contains(be)) {
            this.suboridinates.add(be);
        }
        this.m_6596_();
    }

    protected void setSuperior(ArtilleryCoordinatorBlockEntity block) {
        this.superior = block;
        this.m_6596_();
    }

    public ArtilleryCoordinatorBlockEntity getSuperior() {
        return this.superior;
    }

    protected void removeSuborinate(ArtilleryCoordinatorBlockEntity block) {
        this.suboridinates.remove(block);
        this.m_6596_();
    }

    public void removeSuperior() {
        this.superior.removeSuborinate(this);
        this.superior = null;
        this.m_6596_();
    }

    public BlockEntityType<ArtilleryCoordinatorBlockEntity> m_58903_() {
        return (BlockEntityType)ModBlockEntities.ARTILLERY_COORDINATOR_BLOCK_ENTITY.get();
    }

    public void onRemove() {
        for (Director d : this.directors) {
            d.setNetwork(null);
            this.removeNet(d.getBlockEntity().m_58899_());
        }
        for (Layer c : this.cannons) {
            c.setNetwork(null);
            this.removeNet(c.getBlockEntity().m_58899_());
        }
        for (ArtilleryCoordinatorBlockEntity be : this.suboridinates) {
            be.setSuperior(null);
            be.m_6596_();
        }
        if (this.superior != null) {
            this.superior.removeSubordinate(this);
            this.superior.m_6596_();
        }
        networks.remove(this);
        this.suboridinates.clear();
        this.superior = null;
        this.cannons.clear();
        this.directors.clear();
        this.safeSyncToClients();
    }

    public void setTarget(String targetPos) {
        this.setTargetPos(targetPos);
        if (this.tPos.length == 3) {
            for (Director d : this.directors) {
                d.setTarget(this.tPos);
            }
            for (ArtilleryCoordinatorBlockEntity be : this.suboridinates) {
                be.setTarget(targetPos);
            }
        }
        ModMessages.sendToDimension(new UpdateArtilleryNetDataS2CPacket(new Artillery_CoordinatorInterface(this).getTags()), this.f_58857_);
        double[] array = this.getMedianSet();
        this.medianDisp = array[1];
        this.medianPres = array[0];
        this.medianTTT = array[2];
    }

    public void fire() {
        for (Layer c : this.cannons) {
            c.fire();
        }
        for (ArtilleryCoordinatorBlockEntity be : this.suboridinates) {
            be.fire();
        }
    }

    public int[] getTargetPos() {
        return this.tPos;
    }

    public void target() {
        for (Director d : this.directors) {
            d.target();
        }
        for (ArtilleryCoordinatorBlockEntity be : this.suboridinates) {
            be.target();
        }
    }

    public void setMode(Mode mode) {
        CompoundTag tag = Utils.tagOf(this);
        tag.m_128344_("mode", mode.NUM);
        ModMessages.sendToDimension(new UpdateArtilleryNetDataS2CPacket(tag), this.f_58857_);
        this.mode = mode;
        for (Director d : this.directors) {
            d.mode(mode);
        }
        for (ArtilleryCoordinatorBlockEntity be : this.suboridinates) {
            be.setMode(mode);
        }
    }

    public void addCannon(Layer cannon, Director director) {
        if (!this.cannons.contains(cannon)) {
            this.cannons.add(cannon);
            cannon.setDirector(director);
            cannon.setNetwork(this);
            this.m_6596_();
        }
    }

    public void addDirector(Director director) {
        if (!this.directors.contains(director)) {
            director.setId(this.uniqueDirectorId());
            director.setNetwork(this);
            this.directors.add(director);
            this.m_6596_();
        }
    }

    public void addDirector(Director director, int id) {
        if (!this.directors.contains(director)) {
            director.setId(id);
            director.setNetwork(this);
            this.directors.add(director);
            this.m_6596_();
        }
    }

    public ArrayList<Layer> getLayers(Director director) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Layer i : this.cannons) {
            if (i.getDirector() != director) continue;
            layers.add(i);
        }
        return layers;
    }

    public void removeDirector(Director director) {
        for (Layer i : this.getLayers(director)) {
            i.setNetwork(null);
            this.cannons.remove(i);
            this.removeNet(i.getBlockEntity().m_58899_());
        }
        director.setNetwork(null);
        this.directors.remove(director);
        this.safeSyncToClients();
        this.removeNet(director.getBlockEntity().m_58899_());
        this.m_6596_();
    }

    private void removeNet(BlockPos pos) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ModMessages.sendToPlayersRad(new removeNetworkS2CPacket(pos), Utils.targetPoint(pos, 200, (ResourceKey<Level>)this.f_58857_.m_46472_()));
            this.m_6596_();
        }
    }

    public void removeCannon(Layer cannon) {
        cannon.setNetwork(null);
        this.cannons.remove(cannon);
        this.safeSyncToClients();
        this.removeNet(cannon.getBlockEntity().m_58899_());
        this.m_6596_();
    }

    public String getNetwork_id() {
        return this.network_id;
    }

    public void setNetwork_id(String network_id) {
        CompoundTag tag = Utils.tagOf(this);
        this.network_id = network_id.substring(0, 5);
        tag.m_128359_("new_network_id", network_id);
        ModMessages.sendToDimension(new UpdateArtilleryNetDataS2CPacket(tag), this.f_58857_);
    }

    public ArrayList<Director> getDirectors() {
        return this.directors;
    }

    public ArrayList<Layer> getLayers() {
        return this.cannons;
    }

    private int uniqueDirectorId() {
        if (this.directors.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < 1000; ++i) {
            boolean occupied = false;
            for (Director j : this.directors) {
                if (j.getId() != i) continue;
                occupied = true;
                break;
            }
            if (occupied) continue;
            return i;
        }
        return -1;
    }

    public int numReadyLayers() {
        int num = 0;
        for (Layer i : this.getAllCannons()) {
            if (!i.isSet()) continue;
            ++num;
        }
        if (num != this.prevReady && this.f_58857_ != null) {
            CompoundTag tag = Utils.tagOf(this);
            tag.m_128344_("ready", (byte)num);
            ModMessages.sendToDimension(new UpdateArtilleryNetDataS2CPacket(tag), this.f_58857_);
        }
        this.prevReady = num;
        return num;
    }

    public boolean allSet() {
        for (Director i : this.getAllDirectors()) {
            if (((CalculatorBlockEntity)i).isSet()) continue;
            return false;
        }
        return true;
    }

    private String uniqueNetworkId() {
        boolean found = false;
        while (!found) {
            Object id = "";
            for (int i = 0; i < 5; ++i) {
                id = (String)id + (char)(Math.random() * 26.0 + 97.0);
            }
            found = true;
            for (ArtilleryCoordinatorBlockEntity be : networks) {
                if (be.getNetwork_id() == null || !be.getNetwork_id().equals(id)) continue;
                found = false;
            }
            if (!found) continue;
            return id;
        }
        return null;
    }

    public void appendForTooltip(Collection<Component> pTooltipComponents) {
        String bePosS;
        pTooltipComponents.add((Component)Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.shift"));
        String posS = " \u00a7e(" + Utils.blockPosToString(this.m_58899_()) + ")\u00a7r";
        pTooltipComponents.add((Component)Component.m_237113_((String)(NETWORK.getString() + this.network_id + posS)));
        if (this.superior != null) {
            BlockPos sPos = this.superior.m_58899_();
            String sPosS = " \u00a7e(" + Utils.blockPosToString(sPos) + ")\u00a7r";
            pTooltipComponents.add((Component)Component.m_237113_((String)(SUPER.getString() + this.superior.network_id + sPosS)));
        }
        if (!this.suboridinates.isEmpty()) {
            pTooltipComponents.add(SUB);
            for (ArtilleryCoordinatorBlockEntity be : this.suboridinates) {
                BlockPos pos = be.m_58899_();
                bePosS = " \u00a7e(" + Utils.blockPosToString(pos) + ")\u00a7r";
                pTooltipComponents.add((Component)Component.m_237113_((String)(ARROW.getString() + be.network_id + bePosS)));
            }
        }
        if (!this.directors.isEmpty()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.directors"));
            for (Director i : this.directors) {
                BlockPos pos1 = i.getBlockEntity().m_58899_();
                bePosS = " \u00a7e(" + Utils.blockPosToString(pos1) + ")\u00a7r";
                pTooltipComponents.add((Component)Component.m_237113_((String)(DIRECTOR_ID.getString() + i.getId() + bePosS)));
                for (Layer j : this.getLayers(i)) {
                    BlockPos pos2 = j.getBlockEntity().m_58899_();
                    String bePosS2 = " \u00a7e(" + Utils.blockPosToString(pos2) + ")\u00a7r";
                    pTooltipComponents.add((Component)Component.m_237113_((String)(CANNON.getString() + bePosS2)));
                }
            }
        }
    }

    private void removeEmptyNetworks() {
        for (int i = 0; i < networks.size(); ++i) {
            ArtilleryCoordinatorBlockEntity net = networks.get(i);
            if (!net.getDirectors().isEmpty() || !net.getLayers().isEmpty() || net.getSuperior() != null || !net.getSuboridinates().isEmpty()) continue;
            networks.remove(net);
            --i;
        }
    }

    public Director getDirector(int id) {
        for (Director d : this.directors) {
            if (d.getId() != id) continue;
            return d;
        }
        return null;
    }

    public boolean setTargetPos(String targetPos) {
        this.getPersistentData().m_128359_("targetPos", targetPos);
        this.m_6596_();
        int[] array = new int[3];
        boolean result = Utils.posFromString(targetPos, array);
        if (result) {
            this.tPos = array;
            return true;
        }
        return false;
    }

    protected void m_183515_(CompoundTag pTag) {
        if (this.network_id != null) {
            pTag.m_128359_("network_id", this.network_id);
        }
        int layers = 0;
        for (Director d : this.directors) {
            BlockPos dPos = d.getBlockEntity().m_58899_();
            int[] dPosArray = new int[]{dPos.m_123341_(), dPos.m_123342_(), dPos.m_123343_(), d.getId()};
            pTag.m_128385_("d" + d.getId(), dPosArray);
            for (Layer l : this.getLayers(d)) {
                BlockPos lPos = l.getBlockEntity().m_58899_();
                int[] lPosArray = new int[]{lPos.m_123341_(), lPos.m_123342_(), lPos.m_123343_(), d.getId()};
                pTag.m_128385_("l" + layers, lPosArray);
                ++layers;
            }
        }
        if (this.superior != null) {
            pTag.m_128385_("u", Utils.blockPosToArray(this.superior.m_58899_()));
        }
        for (int i = 0; i < this.suboridinates.size(); ++i) {
            BlockPos pos = this.suboridinates.get(i).m_58899_();
            pTag.m_128385_("s" + i, Utils.blockPosToArray(pos));
        }
        super.m_183515_(pTag);
    }

    public CompoundTag getSaveData() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void reconnectNetwork(CompoundTag pTag) {
        this.removeAllData();
        this.network_id = pTag.m_128461_("network_id");
        if (this.network_id.isEmpty()) {
            this.network_id = this.uniqueNetworkId();
        }
        if (this.f_58857_ != null) {
            BlockEntity be;
            BlockPos pos;
            int[] data;
            Set<String> keys = Set.copyOf(pTag.m_128431_());
            for (String key : keys) {
                BlockEntity be2;
                if (key.charAt(0) == 'd') {
                    data = pTag.m_128465_(key);
                    pos = new BlockPos(data[0], data[1], data[2]);
                    be = this.f_58857_.m_7702_(pos);
                    if (!(be instanceof Director)) continue;
                    this.addDirector((Director)be, data[3]);
                    continue;
                }
                if (key.charAt(0) == 'u') {
                    data = pTag.m_128465_(key);
                    BlockEntity be22 = this.f_58857_.m_7702_(Utils.arrayToBlockPos(data));
                    if (!(be22 instanceof ArtilleryCoordinatorBlockEntity)) continue;
                    ((ArtilleryCoordinatorBlockEntity)be22).superiorOf(this);
                    continue;
                }
                if (key.charAt(0) != 's' || !((be2 = this.f_58857_.m_7702_(Utils.arrayToBlockPos(data = pTag.m_128465_(key)))) instanceof ArtilleryCoordinatorBlockEntity)) continue;
                this.superiorOf((ArtilleryCoordinatorBlockEntity)be2);
            }
            for (String key : keys) {
                if (key.charAt(0) != 'l' || !((be = this.f_58857_.m_7702_(pos = new BlockPos((data = pTag.m_128465_(key))[0], data[1], data[2]))) instanceof Layer)) continue;
                this.addCannon((Layer)be, this.getDirector(data[3]));
            }
        }
    }

    public void removeAllData() {
        int i;
        if (this.superior != null) {
            this.removeSuperior();
        }
        for (i = 0; i < this.suboridinates.size(); ++i) {
            this.removeSubordinate(this.suboridinates.get(i));
            --i;
        }
        for (i = 0; i < this.cannons.size(); ++i) {
            this.removeCannon(this.cannons.get(i));
            --i;
        }
        for (i = 0; i < this.directors.size(); ++i) {
            this.removeDirector(this.directors.get(i));
            --i;
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.saveData = pTag;
        pTag.m_128391_(this.getPersistentData());
        this.m_6596_();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void tick() {
        this.numReadyLayers();
    }

    public void onLoad() {
        if (this.saveData != null) {
            this.reconnectNetwork(this.saveData);
        }
        if (this.network_id == null || this.network_id.isEmpty()) {
            this.network_id = this.uniqueNetworkId();
        }
        this.removeEmptyNetworks();
        networks.add(this);
        super.onLoad();
    }

    public void safeSyncToClient(Player player) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> this.syncToClient(player));
    }

    public void syncToClient(Player player) {
        ModMessages.sendToPlayer(new SyncArtilleryNetS2CPacket(this.m_58899_(), this.getSaveData()), (ServerPlayer)player);
        for (ArtilleryCoordinatorBlockEntity be : this.suboridinates) {
            be.syncToClient(player);
        }
    }

    public void safeSyncToClients() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> this.syncToClients());
    }

    public void syncToClients() {
        ModMessages.sendToPlayersRad(new SyncArtilleryNetS2CPacket(this.m_58899_(), this.getSaveData()), Utils.targetPoint(this.m_58899_(), 200, (ResourceKey<Level>)this.f_58857_.m_46472_()));
        for (ArtilleryCoordinatorBlockEntity be : this.suboridinates) {
            be.syncToClients();
        }
    }

    public void openScreen(Player player, boolean allowIdChange) {
        ModMessages.sendToPlayer(new OpenCoordinatorS2CPacket(this, allowIdChange), (ServerPlayer)player);
    }

    public ArtilleryCoordinatorBlockEntity topHierarchy() {
        if (this.superior != null) {
            return this.superior.topHierarchy();
        }
        return this;
    }

    public ArrayList<Director> getAllDirectors() {
        ArrayList array = (ArrayList)this.directors.clone();
        for (ArtilleryCoordinatorBlockEntity be : this.suboridinates) {
            array.addAll(be.getAllDirectors());
        }
        return array;
    }

    public ArrayList<Layer> getAllCannons() {
        ArrayList array = (ArrayList)this.cannons.clone();
        for (ArtilleryCoordinatorBlockEntity be : this.suboridinates) {
            array.addAll(be.getAllCannons());
        }
        return array;
    }

    public double[] getMedianSet() {
        ArrayList<Director> array = this.getAllDirectors();
        double[] pres = new double[array.size()];
        double[] disp = new double[array.size()];
        double[] tTT = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            FiringSolutions.Solution result = ((CalculatorBlockEntity)array.get(i)).getResult();
            if (result == null) continue;
            pres[i] = result.PRECISION;
            disp[i] = result.DISPERSION;
            tTT[i] = result.AIR_TIME;
        }
        return new double[]{Utils.median(pres), Utils.median(disp), Utils.median(tTT)};
    }

    public double getMedianDisp() {
        return this.medianDisp;
    }

    public double getMedianPres() {
        return this.medianPres;
    }

    public double getMedianTTT() {
        return this.medianTTT;
    }

    public static ArtilleryCoordinatorBlockEntity fromId(String id) {
        for (ArtilleryCoordinatorBlockEntity be : networks) {
            if (!be.getNetwork_id().equals(id)) continue;
            return be;
        }
        return null;
    }

    public void line(Level level, boolean isCentre) {
        try {
            if (level != null && level.f_46443_) {
                if (this.superior != null && isCentre) {
                    ParticleHelper.line(level, this.m_58899_(), this.superior.m_58899_(), ParticleHelper.Colour.YELLOW, 1.0f);
                }
                for (ArtilleryCoordinatorBlockEntity be : this.suboridinates) {
                    ParticleHelper.line(level, this.m_58899_(), be.m_58899_(), ParticleHelper.Colour.WHITE, 1.0f);
                    be.line(level, false);
                }
                for (Director d : this.directors) {
                    BlockPos pos = d.getBlockEntity().m_58899_();
                    ParticleHelper.line(level, this.m_58899_(), pos, ParticleHelper.Colour.BLUE, 1.0f);
                    for (Layer l : this.getLayers(d)) {
                        ParticleHelper.line(level, pos, l.getBlockEntity().m_58899_(), ParticleHelper.Colour.GREEN, 1.0f);
                    }
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Override
    public ArtilleryCoordinatorBlockEntity getNetwork() {
        return this;
    }

    @Override
    public void removeNetwork() {
    }

    public void removeNetwork(ArtilleryCoordinatorBlockEntity net) {
        if (this.superior != null && this.superior == net) {
            net.removeSubordinate(this);
            this.superior = null;
        } else if (this.suboridinates.contains(net)) {
            net.setSuperior(null);
            this.removeSubordinate(net);
        }
        this.m_6596_();
    }

    public static enum Mode {
        INDIRECT(0),
        DIRECT(1),
        PRECISE(2),
        DISPERSION(3);

        public final byte NUM;

        private Mode(byte num) {
            this.NUM = num;
        }

        public Mode next() {
            if (this.NUM + 1 <= 3) {
                return Mode.fromByte((byte)(this.NUM + 1));
            }
            return INDIRECT;
        }

        public static Mode fromByte(byte num) {
            for (Mode mode : (Mode[])Mode.class.getEnumConstants()) {
                if (mode.NUM != num) continue;
                return mode;
            }
            return null;
        }

        public Component getComponent() {
            return switch (this.NUM) {
                case 0 -> Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.indirect");
                case 1 -> Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.direct");
                case 2 -> Component.m_237115_((String)"block.cbc_ballistics.artillery_network.pres");
                case 3 -> Component.m_237115_((String)"block.cbc_ballistics.artillery_network.dis");
                default -> Component.m_237113_((String)"unknown material");
            };
        }
    }
}

