/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.block.entity;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.felis.cbc_ballistics.block.ModBlocks;
import net.felis.cbc_ballistics.block.entity.ArtilleryCoordinatorBlockEntity;
import net.felis.cbc_ballistics.block.entity.CannonControllerBlockEntity;
import net.felis.cbc_ballistics.block.entity.ModBlockEntities;
import net.felis.cbc_ballistics.networking.ModMessages;
import net.felis.cbc_ballistics.networking.packet.artilleryCoordinator.sendSolutionsS2CPacket;
import net.felis.cbc_ballistics.networking.packet.ballisticCalculator.SyncCalculatorC2SPacket;
import net.felis.cbc_ballistics.networking.packet.ballisticCalculator.SyncCalculatorS2CPacket;
import net.felis.cbc_ballistics.util.Utils;
import net.felis.cbc_ballistics.util.artilleryNetwork.Director;
import net.felis.cbc_ballistics.util.artilleryNetwork.Layer;
import net.felis.cbc_ballistics.util.calculator.Cannon;
import net.felis.cbc_ballistics.util.calculator.FiringSolutions;
import net.felis.cbc_ballistics.util.calculator.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;

public class CalculatorBlockEntity
extends BlockEntity
implements MenuProvider,
IHaveGoggleInformation,
Director {
    private static final Component CHARGES = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.charge");
    private static final Component PITCH = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.pitch");
    private static final Component YAW = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.yaw");
    private static final Component OUT_OF_RANGE = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.outOfRange");
    private boolean calculate = false;
    private boolean isDirectFire = false;
    private Material material;
    private int[] cPos = new int[3];
    private int[] tPos = new int[3];
    private int minP;
    private int maxP;
    private int len;
    private int minC;
    private int maxC;
    private float grav;
    private float drg;
    private FiringSolutions results;
    private boolean ready = false;
    private boolean tooFar;
    private ArtilleryCoordinatorBlockEntity network;
    private int id;
    private byte redstonePulse = (byte)-1;

    public CalculatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.CALCULATORBLOCKENTITY.get(), pPos, pBlockState);
        CompoundTag pTag = this.getPersistentData();
        pTag.m_128359_("cannonPos", "");
        pTag.m_128359_("targetPos", "");
        pTag.m_128359_("maxPitch", "60");
        pTag.m_128359_("minPitch", "-30");
        pTag.m_128359_("length", "");
        pTag.m_128359_("minCharge", "");
        pTag.m_128359_("maxCharge", "");
        pTag.m_128405_("material", 3);
        pTag.m_128359_("gravity", "0.05");
        pTag.m_128359_("drag", "0.99");
        this.material = Material.STEEL;
        this.minP = -30;
        this.maxP = 60;
        this.grav = 0.05f;
        this.drg = 0.99f;
        this.minC = 1;
        this.maxC = 1;
        this.tooFar = false;
    }

    public void calculate() {
        if (!this.f_58857_.f_46443_) {
            Cannon myCannon = new Cannon.Builder(this.f_58857_).at(Utils.arrayToBlockPos(this.cPos)).grav(this.grav).length(this.len).drag(this.drg).minCharge(this.minC).maxCharge(this.maxC).minPitch(this.minP).maxPitch(this.maxP).material(this.material).build();
            this.ready = true;
            try {
                this.results = myCannon.interpolateTarget(Utils.arrayToBlockPos(this.tPos));
                this.tooFar = false;
            }
            catch (RuntimeException e) {
                System.out.println(e.toString());
                this.tooFar = true;
                this.results = new FiringSolutions();
            }
            finally {
                ModMessages.sendToPlayersRad(new sendSolutionsS2CPacket(this.m_58899_(), this.results), Utils.targetPoint(this.m_58899_(), 160, (ResourceKey<Level>)this.f_58857_.m_46472_()));
            }
        }
    }

    public void setSolutions(FiringSolutions solutions) {
        if (solutions == null) {
            this.tooFar = true;
        }
        this.ready = true;
        this.results = solutions;
    }

    public boolean isReady() {
        return this.ready;
    }

    public FiringSolutions getResults() {
        return this.results;
    }

    public FiringSolutions.Solution getResult() {
        if (this.results != null) {
            if (this.isDirectFire) {
                return this.results.DIRECT;
            }
            return this.results.INDIRECT;
        }
        return null;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return null;
    }

    public Component getMaterial() {
        return this.material.getComponent();
    }

    public boolean getCalculateButton() {
        return this.calculate;
    }

    public boolean isDirectFire() {
        return this.isDirectFire;
    }

    public boolean setCannonPos(String cannonPos) {
        this.getPersistentData().m_128359_("cannonPos", cannonPos);
        this.m_6596_();
        int[] array = new int[3];
        boolean result = Utils.posFromString(cannonPos, array);
        if (result) {
            this.cPos = array;
            return true;
        }
        return false;
    }

    public boolean setDrag(String drag) {
        this.getPersistentData().m_128359_("drag", drag);
        this.m_6596_();
        try {
            this.drg = Float.parseFloat(drag);
            return this.drg > 0.0f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean setMaxCharge(String maxCharge) {
        this.getPersistentData().m_128359_("maxCharge", maxCharge);
        this.m_6596_();
        try {
            this.maxC = Integer.parseInt(maxCharge);
            return this.maxC >= this.minC && this.maxC > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void onRemove() {
        if (this.network != null) {
            this.network.removeDirector(this);
        }
    }

    public boolean setMinCharge(String minCharge) {
        this.getPersistentData().m_128359_("minCharge", minCharge);
        this.m_6596_();
        try {
            this.minC = Integer.parseInt(minCharge);
            return this.minC <= this.maxC && this.minC > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean setGravity(String gravity) {
        this.getPersistentData().m_128359_("gravity", gravity);
        this.m_6596_();
        try {
            this.grav = Float.parseFloat(gravity);
            return this.grav > 0.0f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isTooFar() {
        return this.tooFar;
    }

    public boolean setLength(String length) {
        this.getPersistentData().m_128359_("length", length);
        this.m_6596_();
        try {
            this.len = Integer.parseInt(length);
            return this.len > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void cycleMaterial() {
        this.material = this.material.next();
        this.getPersistentData().m_128405_("material", (int)this.material.no);
        this.m_6596_();
    }

    public void cycleMode() {
        this.isDirectFire = !this.isDirectFire;
    }

    public boolean setMaxPitch(String maxPitch) {
        this.getPersistentData().m_128359_("maxPitch", maxPitch);
        this.m_6596_();
        try {
            this.maxP = Integer.parseInt(maxPitch);
            return this.maxP > this.minP && this.maxP < 90;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean setMinPitch(String minPitch) {
        this.getPersistentData().m_128359_("minPitch", minPitch);
        this.m_6596_();
        try {
            this.minP = Integer.parseInt(minPitch);
            return this.minP < this.maxP && this.minP > -90;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean setTargetPos(String targetPos) {
        this.getPersistentData().m_128359_("targetPos", targetPos);
        this.m_6596_();
        int[] array = new int[3];
        boolean result = Utils.posFromString(targetPos, array);
        if (result) {
            this.tPos = array;
            return true;
        }
        return false;
    }

    public Component getMode() {
        if (this.isDirectFire) {
            return Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.direct");
        }
        return Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.indirect");
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128405_("material", (int)this.material.no);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        pTag.m_128391_(this.getPersistentData());
        this.m_6596_();
        this.material = Material.fromInt(pTag.m_128451_("material"));
        this.setCannonPos(pTag.m_128461_("cannonPos"));
        this.setTargetPos(pTag.m_128461_("targetPos"));
        this.setMinPitch(pTag.m_128461_("minPitch"));
        this.setMaxPitch(pTag.m_128461_("maxPitch"));
        this.setLength(pTag.m_128461_("length"));
        this.setGravity(pTag.m_128461_("gravity"));
        this.setDrag(pTag.m_128461_("drag"));
        this.setMaxCharge(pTag.m_128461_("maxCharge"));
        this.setMinCharge(pTag.m_128461_("minCharge"));
    }

    public void sync(Boolean calculate) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ModMessages.sendToServer(new SyncCalculatorC2SPacket(this.m_58899_(), this.getPersistentData(), calculate)));
    }

    public void syncFrom(CompoundTag pTag) {
        this.material = Material.fromInt(pTag.m_128451_("material"));
        this.setCannonPos(pTag.m_128461_("cannonPos"));
        this.setTargetPos(pTag.m_128461_("targetPos"));
        this.setMinPitch(pTag.m_128461_("minPitch"));
        this.setMaxPitch(pTag.m_128461_("maxPitch"));
        this.setLength(pTag.m_128461_("length"));
        this.setGravity(pTag.m_128461_("gravity"));
        this.setDrag(pTag.m_128461_("drag"));
        this.setMaxCharge(pTag.m_128461_("maxCharge"));
        this.setMinCharge(pTag.m_128461_("minCharge"));
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator")));
        if (this.tooFar) {
            tooltip.add(OUT_OF_RANGE);
        } else if (this.results != null) {
            double yaw = (double)Math.round(this.results.YAW * 1000.0f) / 1000.0;
            double pitch = (double)Math.round(this.getResult().PITCH * 1000.0f) / 1000.0;
            tooltip.add((Component)PITCH.m_6881_().m_130946_("" + pitch));
            tooltip.add((Component)YAW.m_6881_().m_130946_("" + yaw));
            tooltip.add((Component)CHARGES.m_6881_().m_130946_(": " + this.getResult().CHARGES));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.tooltip.need_results"));
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    @Override
    public void setTarget(int[] target) {
        this.getPersistentData().m_128359_("targetPos", "X = " + target[0] + ", Y =" + target[1] + ", Z = " + target[2]);
        this.m_6596_();
        this.tPos = target;
        this.calculate();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ModMessages.sendToPlayersRad(new SyncCalculatorS2CPacket(this.m_58899_(), target), Utils.targetPoint(this.m_58899_(), 200, (ResourceKey<Level>)this.f_58857_.m_46472_()));
        }
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public ArtilleryCoordinatorBlockEntity getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(ArtilleryCoordinatorBlockEntity network) {
        this.network = network;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public void target() {
        if (this.results != null) {
            FiringSolutions.Solution projectile = this.getResult();
            for (Layer c : this.network.getLayers(this)) {
                c.setTarget(projectile.PITCH, projectile.YAW);
            }
            this.redstonePulse = (byte)8;
        }
    }

    public void tick() {
        this.redstonePulse();
    }

    private void redstonePulse() {
        if (this.redstonePulse == 0) {
            this.redstonePulse = (byte)-1;
            this.f_58857_.m_46672_(this.m_58899_(), (Block)ModBlocks.BALLISTIC_CALCULATOR.get());
        } else if (this.redstonePulse > 0) {
            this.redstonePulse = (byte)(this.redstonePulse - 1);
            this.f_58857_.m_46672_(this.m_58899_(), (Block)ModBlocks.BALLISTIC_CALCULATOR.get());
        }
    }

    public int getRedstoneOutput() {
        if (this.redstonePulse < 1) {
            return 0;
        }
        if (this.results != null) {
            return this.getResult().CHARGES;
        }
        return 0;
    }

    @Override
    public void mode(ArtilleryCoordinatorBlockEntity.Mode mode) {
        switch (mode) {
            case INDIRECT: {
                this.isDirectFire = false;
                break;
            }
            case DIRECT: {
                this.isDirectFire = true;
                break;
            }
            case PRECISE: {
                if (this.results == null) break;
                this.isDirectFire = !(this.results.DIRECT.PRECISION < this.results.INDIRECT.PRECISION);
                break;
            }
            case DISPERSION: {
                if (this.results == null) break;
                this.isDirectFire = !(this.results.DIRECT.DISPERSION < this.results.INDIRECT.DISPERSION);
            }
        }
    }

    @Override
    public void removeNetwork() {
        if (this.network != null) {
            this.network.removeDirector(this);
        }
    }

    public boolean isSet() {
        if (this.results != null) {
            FiringSolutions.Solution result = this.getResult();
            float pitch = result.PITCH;
            float yaw = result.YAW;
            for (Layer l : this.network.getLayers(this)) {
                CannonControllerBlockEntity c;
                if (!(l instanceof CannonControllerBlockEntity) || (c = (CannonControllerBlockEntity)l).getTargetYaw() == yaw && c.getTargetPitch() == pitch) continue;
                return false;
            }
        }
        return true;
    }
}

