/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.block.entity;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.felis.cbc_ballistics.block.entity.ArtilleryCoordinatorBlockEntity;
import net.felis.cbc_ballistics.util.Utils;
import net.felis.cbc_ballistics.util.artilleryNetwork.Director;
import net.felis.cbc_ballistics.util.artilleryNetwork.Layer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;

public class CannonControllerBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation,
Layer {
    private static final Logger log = LoggerFactory.getLogger(CannonControllerBlockEntity.class);
    private float targetPitch;
    private float targetYaw;
    private CannonMountBlockEntity cannon;
    private boolean active;
    private boolean setting;
    private boolean fire = false;
    private Director director;
    private ArtilleryCoordinatorBlockEntity network;

    public CannonControllerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void onRemove() {
        if (this.network != null) {
            this.network.removeCannon(this);
        }
    }

    public void onPlace(Level level) {
        PitchOrientedContraptionEntity mount;
        this.cannon = this.findCannon(level);
        if (this.cannon != null && (mount = this.cannon.getContraption()) != null) {
            this.targetPitch = 0.0f;
            this.targetYaw = 0.0f;
        }
        this.active = false;
        this.setting = false;
        this.fire = false;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (this.cannon == null && !pLevel.f_46443_) {
            PitchOrientedContraptionEntity mount;
            this.cannon = this.findCannon(pLevel);
            if (this.cannon != null && (mount = this.cannon.getContraption()) != null) {
                this.targetPitch = mount.pitch;
                this.targetYaw = Math.abs(mount.yaw) % 360.0f;
                if (this.targetYaw > 180.0f) {
                    this.targetYaw -= 360.0f;
                }
            }
        }
    }

    public void tick() {
        super.tick();
        this.tryFire();
        this.rotateCannon();
    }

    private void rotateCannon() {
        PitchOrientedContraptionEntity mount;
        if (this.cannon != null && this.f_58857_ != null && !this.f_58857_.f_46443_ && (mount = this.cannon.getContraption()) != null) {
            this.updateNetwork(true);
            if (this.setting) {
                float speed = Math.abs(this.getTheoreticalSpeed() * 0.04f);
                boolean changed = false;
                float pitch = mount.pitch * Math.signum(mount.getInitialOrientation().m_122429_() - mount.getInitialOrientation().m_122431_());
                float yaw = (mount.yaw + 360.0f) % 360.0f;
                if (yaw > 180.0f) {
                    yaw -= 360.0f;
                }
                if (pitch != this.targetPitch) {
                    changed = true;
                    if (Math.abs(this.targetPitch - pitch) > speed) {
                        float movement = pitch > this.targetPitch ? -speed : speed;
                        this.cannon.setPitch(pitch + movement);
                    } else {
                        this.cannon.setPitch(this.targetPitch);
                    }
                }
                if (yaw != this.targetYaw) {
                    changed = true;
                    float yawDiff = this.targetYaw - yaw;
                    if (Math.abs(yawDiff) > speed) {
                        float movement = yawDiff > 180.0f ? -speed : (yawDiff < -180.0f ? speed : (yawDiff > 0.0f ? speed : -speed));
                        this.cannon.setYaw(yaw + movement);
                    } else {
                        this.cannon.setYaw(this.targetYaw);
                    }
                }
                if (changed) {
                    this.cannon.notifyUpdate();
                } else {
                    this.setting = false;
                }
            }
            return;
        }
        this.updateNetwork(false);
    }

    protected boolean isNoisy() {
        return false;
    }

    private void updateNetwork(boolean active) {
        if (active == this.active) {
            if (this.getOrCreateNetwork() != null) {
                this.stress += this.getAddedStress();
                this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.getAddedStress());
            }
            this.active = !active;
        }
    }

    @Override
    public void setDirector(Director director) {
        this.director = director;
    }

    @Override
    public Director getDirector() {
        return this.director;
    }

    @Override
    public ArtilleryCoordinatorBlockEntity getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(ArtilleryCoordinatorBlockEntity network) {
        this.network = network;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public void setTarget(float pitch, float yaw) {
        this.setting = true;
        this.targetYaw = Math.abs(yaw) % 360.0f;
        if (this.targetYaw > 180.0f) {
            this.targetYaw -= 360.0f;
        }
        this.targetPitch = pitch;
    }

    @Override
    public boolean isSet() {
        return !this.setting;
    }

    @Override
    public void fire() {
        this.fire = true;
    }

    public boolean tryFire() {
        if (this.fire && this.cannon != null && this.cannon.isRunning() && this.cannon.getContraption() != null) {
            Level level = this.m_58904_();
            this.fire = false;
            if (level instanceof ServerLevel) {
                ServerLevel slevel = (ServerLevel)level;
                PitchOrientedContraptionEntity mountedContraption = this.cannon.getContraption();
                ((AbstractMountedCannonContraption)mountedContraption.getContraption()).onRedstoneUpdate(slevel, mountedContraption, true, 3, (ControlPitchContraption)this.cannon);
            }
            return true;
        }
        return false;
    }

    public float calculateStressApplied() {
        if (this.f_58857_ != null && this.cannon == null) {
            this.cannon = this.findCannon(this.f_58857_);
        }
        return this.getAddedStress();
    }

    public float getAddedStress() {
        if (this.cannon != null && this.cannon.getContraption() != null) {
            float cannonStress = ((AbstractMountedCannonContraption)this.cannon.getContraption().getContraption()).getWeightForStress();
            return cannonStress * 2.0f;
        }
        return 0.0f;
    }

    private CannonMountBlockEntity findCannon(Level level) {
        BlockEntity block = level.m_7702_(this.f_58858_.m_122029_());
        if (block instanceof CannonMountBlockEntity) {
            return (CannonMountBlockEntity)block;
        }
        block = level.m_7702_(this.f_58858_.m_122019_());
        if (block instanceof CannonMountBlockEntity) {
            return (CannonMountBlockEntity)block;
        }
        block = level.m_7702_(this.f_58858_.m_122024_());
        if (block instanceof CannonMountBlockEntity) {
            return (CannonMountBlockEntity)block;
        }
        block = level.m_7702_(this.f_58858_.m_122012_());
        if (block instanceof CannonMountBlockEntity) {
            return (CannonMountBlockEntity)block;
        }
        block = level.m_7702_(this.f_58858_.m_7494_());
        if (block instanceof CannonMountBlockEntity) {
            return (CannonMountBlockEntity)block;
        }
        block = level.m_7702_(this.f_58858_.m_7495_());
        if (block instanceof CannonMountBlockEntity) {
            return (CannonMountBlockEntity)block;
        }
        return null;
    }

    public void onLoad() {
        if (this.cannon == null && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.cannon = this.findCannon(this.f_58857_);
        }
        this.read(this.getPersistentData(), false);
        super.onLoad();
    }

    public float getTargetPitch() {
        return this.targetPitch;
    }

    public float getTargetYaw() {
        return this.targetYaw;
    }

    public float getCannonPitch() {
        if (this.cannon != null && this.cannon.getCannonMount() != null) {
            return this.cannon.getContraption().pitch;
        }
        return 0.0f;
    }

    public float getCannonYaw() {
        if (this.cannon != null) {
            if (this.cannon.getCannonMount() != null) {
                return this.cannon.getContraption().yaw;
            }
            Direction facing = (Direction)this.cannon.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            return Utils.yawFromFacing(facing);
        }
        return 0.0f;
    }

    @Override
    public void removeNetwork() {
        if (this.network != null) {
            this.network.removeCannon(this);
        }
    }
}

