/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.entity.custom;

import net.felis.cbc_ballistics.entity.ModEntities;
import net.felis.cbc_ballistics.util.Utils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Vector3f;

public class DetectingProjectile
extends Projectile {
    private HitResult results;
    private int range;
    private float drag;
    private float grav;
    private boolean allowHitEntity;
    private double distanceTravelled;
    private float angle_of_attack;

    public DetectingProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public HitResult getResults() {
        return this.results;
    }

    public double getDistTravelled() {
        return this.distanceTravelled;
    }

    private DetectingProjectile(Level level, Vec3 pos, float drag, float grav, boolean allowHitEntity, int range) {
        super((EntityType)ModEntities.DETECTING_PROJECTILE.get(), level);
        this.grav = grav;
        this.drag = drag;
        this.range = range;
        this.distanceTravelled = 0.0;
        this.allowHitEntity = allowHitEntity;
        this.m_146884_(pos);
    }

    protected void m_6532_(HitResult pResult) {
        Vec3 pos = this.m_20182_();
        this.move();
        Vec3 next = this.m_20182_();
        this.distanceTravelled += Utils.distFrom(pos, pResult.m_82450_());
        this.angle_of_attack = -((float)Math.toDegrees(Math.atan((next.f_82480_ - pos.f_82480_) / Math.sqrt(Math.pow(next.f_82479_ - pos.f_82479_, 2.0) + Math.pow(next.f_82481_ - pos.f_82481_, 2.0)))));
        super.m_6532_(pResult);
    }

    public float getAngle_of_attack() {
        return this.angle_of_attack;
    }

    protected void m_8060_(BlockHitResult pResult) {
        this.results = pResult;
        super.m_8060_(pResult);
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult pResult) {
        this.results = pResult;
        super.m_5790_(pResult);
        this.m_146870_();
    }

    protected void m_8097_() {
    }

    private HitResult simulate(float xRot, float yRot, float pVelocity) {
        Vector3f vel = Utils.vecToVel(xRot, yRot, 1.0f);
        super.m_6686_((double)vel.x, (double)vel.y, (double)vel.z, pVelocity, 0.0f);
        boolean hitBlock = false;
        for (int i = 0; i < this.range && !hitBlock; ++i) {
            hitBlock = this.subtick();
        }
        if (!hitBlock) {
            this.m_146870_();
        }
        return this.results;
    }

    protected boolean m_5603_(Entity pTarget) {
        if (this.allowHitEntity) {
            return super.m_5603_(pTarget);
        }
        return false;
    }

    private boolean subtick() {
        this.m_20101_();
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        if (!(hitresult.m_6662_() == HitResult.Type.MISS || ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult) || hitresult.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)hitresult).m_82443_().equals((Object)this.m_19749_()))) {
            this.m_6532_(hitresult);
            return true;
        }
        this.move();
        this.m_20101_();
        return false;
    }

    public void move() {
        Vec3 vel = this.m_20184_();
        this.distanceTravelled += vel.m_82553_();
        this.m_6034_(this.m_20185_() + vel.f_82479_, this.m_20186_() + vel.f_82480_, this.m_20189_() + vel.f_82481_);
        this.m_20334_(vel.f_82479_ * (double)this.drag, vel.f_82480_ * (double)this.drag - (double)this.grav, vel.f_82481_ * (double)this.drag);
    }

    public static class Detect {
        private Vec3 pos;
        private float drag = 1.0f;
        private float grav = 0.0f;
        private boolean hitEntity = true;
        private Level level;
        private int range = 64;

        public Detect(Level level, Vec3 pos) {
            this.level = level;
            this.pos = pos;
        }

        public Detect(Level level, double x, double y, double z) {
            this.level = level;
            this.pos = new Vec3(x, y, z);
        }

        public Detect drag(float drag) {
            this.drag = drag;
            return this;
        }

        public Detect grav(float grav) {
            this.grav = grav;
            return this;
        }

        public Detect range(int range) {
            this.range = range;
            return this;
        }

        public Detect allowHitEntity(boolean hitEntity) {
            this.hitEntity = hitEntity;
            return this;
        }

        public DetectingProjectile simulate(float xRot, float yRot, float pVelocity) {
            DetectingProjectile projectile = new DetectingProjectile(this.level, this.pos, this.drag, this.grav, this.hitEntity, this.range);
            projectile.simulate(xRot, yRot, pVelocity);
            return projectile;
        }
    }
}

