/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.event;

import net.felis.cbc_ballistics.entity.model.RadioModel;
import net.felis.cbc_ballistics.item.ModItems;
import net.felis.cbc_ballistics.item.custom.RadioItem;
import net.felis.cbc_ballistics.item.custom.RangefinderItem;
import net.felis.cbc_ballistics.util.KeyBinding;
import net.felis.cbc_ballistics.util.ScreenDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cbc_ballistics", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ModClientEvents {
    public static ScreenDisplay SCREEN;
    private boolean isScoped = false;
    private boolean normalise = false;
    private double sensitivity = 100.0;

    public ModClientEvents() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            SCREEN = new ScreenDisplay();
        });
    }

    @SubscribeEvent
    public void onComputerFovModifierEvent(ComputeFovModifierEvent event) {
        if (!this.isScoped) {
            this.sensitivity = (Double)Minecraft.m_91087_().f_91066_.m_231964_().m_231551_();
        }
        this.normalise = false;
        if (event.getPlayer().m_21211_().m_41720_() == ModItems.RANGEFINDER.get() && event.getPlayer().m_6117_() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
            this.isScoped = true;
            event.setNewFovModifier(0.1f);
            Minecraft.m_91087_().f_91066_.m_231964_().m_231514_((Object)(this.sensitivity / 10.0));
            this.normalise = true;
        } else {
            this.isScoped = false;
            if (!this.normalise) {
                Minecraft.m_91087_().f_91066_.m_231964_().m_231514_((Object)this.sensitivity);
            }
        }
    }

    @SubscribeEvent
    public void renderRangefinder(RenderGuiOverlayEvent event) {
        GuiGraphics graphics = event.getGuiGraphics();
        if (this.isScoped) {
            int screenWidth = graphics.m_280182_();
            int screenHeight = graphics.m_280206_();
            float f = Math.min(screenWidth, screenHeight);
            int i = Mth.m_14107_((double)((double)f * 1.125));
            int k = (screenWidth - i) / 2;
            int l = (screenHeight - i) / 2;
            int i1 = k + i;
            int j1 = l + i;
            graphics.m_280398_(new ResourceLocation("cbc_ballistics:textures/misc/rangefinder.png"), k, l, -90, 0.0f, 0.0f, i, i, i, i);
            graphics.m_285795_(RenderType.m_286086_(), 0, j1, screenWidth, screenHeight, -90, -16777216);
            graphics.m_285795_(RenderType.m_286086_(), 0, 0, screenWidth, l, -90, -16777216);
            graphics.m_285795_(RenderType.m_286086_(), 0, l, k, j1, -90, -16777216);
            graphics.m_285795_(RenderType.m_286086_(), i1, l, screenWidth, j1, -90, -16777216);
        }
        if (SCREEN != null) {
            SCREEN.display(graphics);
        }
    }

    @Mod.EventBusSubscriber(modid="cbc_ballistics", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(KeyBinding.OPEN_RADIO_KEY);
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(RadioModel.LAYER_LOCATION, RadioModel::createBodyLayer);
        }
    }

    @Mod.EventBusSubscriber(modid="cbc_ballistics", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void onKeyInputMouse(InputEvent.MouseButton event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && player.m_9236_().f_46443_) {
                ItemStack thing;
                Item item;
                ItemStack stack = player.m_21211_();
                int button = event.getButton();
                int action = event.getAction();
                if (button == 0 && action == 1 && player.m_6117_() && stack.m_41720_() == ModItems.RANGEFINDER.get() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && (item = (thing = player.m_21211_()).m_41720_()) instanceof RangefinderItem) {
                    RangefinderItem rangefinder = (RangefinderItem)item;
                    rangefinder.rangeFind(thing, (Player)player);
                }
            }
        }

        @SubscribeEvent
        public static void onKeyInputKey(InputEvent.Key event) {
            ItemStack chestplate;
            Item item;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (KeyBinding.OPEN_RADIO_KEY.m_90859_() && (item = (chestplate = (ItemStack)player.m_150109_().f_35975_.get(2)).m_41720_()) instanceof RadioItem) {
                RadioItem radio = (RadioItem)item;
                if (chestplate.m_41784_().m_128441_("network")) {
                    radio.openRadio(chestplate);
                } else {
                    SCREEN.add((Component)Component.m_237115_((String)"item.cbc_ballistics.radio_item.empty"), 6000);
                }
            }
        }
    }
}

