/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.item.custom;

import java.util.List;
import net.felis.cbc_ballistics.block.entity.ArtilleryCoordinatorBlockEntity;
import net.felis.cbc_ballistics.networking.ModMessages;
import net.felis.cbc_ballistics.networking.packet.SyncManagerItemS2CPacket;
import net.felis.cbc_ballistics.util.IHaveData;
import net.felis.cbc_ballistics.util.Utils;
import net.felis.cbc_ballistics.util.artilleryNetwork.Director;
import net.felis.cbc_ballistics.util.artilleryNetwork.Layer;
import net.felis.cbc_ballistics.util.artilleryNetwork.NetworkComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;

public class ArtilleryNetworkManagerItem
extends Item
implements IHaveData {
    private ArtilleryCoordinatorBlockEntity network;
    private Director selected;
    private int cooldown = 0;

    public ArtilleryNetworkManagerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        if (pContext.m_43724_() == InteractionHand.MAIN_HAND && !level.f_46443_) {
            Player player = pContext.m_43723_();
            BlockEntity be = level.m_7702_(pContext.m_8083_());
            if (be instanceof NetworkComponent) {
                NetworkComponent c = (NetworkComponent)be;
                if (this.network == null) {
                    this.network = c.getNetwork();
                    if (c instanceof Director) {
                        Director d;
                        this.selected = d = (Director)c;
                    }
                } else if (c.getNetwork() == this.network) {
                    if (c instanceof Director) {
                        Director d = (Director)c;
                        if (d == this.selected) {
                            this.disconnect(d);
                        } else {
                            this.selected = d;
                        }
                    } else {
                        this.disconnect(c);
                    }
                } else if (c instanceof ArtilleryCoordinatorBlockEntity) {
                    ArtilleryCoordinatorBlockEntity n = (ArtilleryCoordinatorBlockEntity)c;
                    ArtilleryCoordinatorBlockEntity s = n.getSuperior();
                    if (s != null && s == this.network || n.getSuboridinates().contains(this.network)) {
                        this.disconnect(c);
                    } else {
                        this.connect(c);
                    }
                } else {
                    this.connect(c);
                }
                if (this.network != null) {
                    this.network.safeSyncToClient(pContext.m_43723_());
                }
                this.syncToClient(player);
            } else {
                this.network = null;
                this.selected = null;
                this.syncToClient(player);
            }
        }
        return super.m_6225_(pContext);
    }

    public void setNetwork(ArtilleryCoordinatorBlockEntity net) {
        this.network = net;
    }

    public void setSelected(Director dir) {
        this.selected = dir;
    }

    private void connect(NetworkComponent c) {
        ArtilleryCoordinatorBlockEntity n;
        if (c instanceof ArtilleryCoordinatorBlockEntity && !(n = (ArtilleryCoordinatorBlockEntity)c).getSuboridinates().contains(this.network) && Utils.distFrom(n, this.network) <= 1.0E9) {
            this.network.superiorOf(n);
        } else if (c.getNetwork() == null) {
            Layer l;
            Director d;
            if (c instanceof Director && Utils.distFrom((d = (Director)c).getBlockEntity(), this.network) <= 50.0) {
                this.network.addDirector(d);
                this.selected = d;
            } else if (this.selected != null && c instanceof Layer && Utils.distFrom((l = (Layer)c).getBlockEntity(), this.selected.getBlockEntity()) <= 25.0) {
                this.network.addCannon(l, this.selected);
            }
        }
    }

    private void disconnect(NetworkComponent c) {
        if (c instanceof ArtilleryCoordinatorBlockEntity) {
            ArtilleryCoordinatorBlockEntity n = (ArtilleryCoordinatorBlockEntity)c;
            this.network.removeNetwork(n);
        } else if (c.getNetwork() == this.network) {
            Director d;
            if (c instanceof Director && this.selected == (d = (Director)c)) {
                this.network.removeDirector(d);
            } else if (c instanceof Layer) {
                Layer l = (Layer)c;
                this.network.removeCannon(l);
            }
        }
    }

    public boolean m_5812_(ItemStack pStack) {
        return this.network != null;
    }

    @Override
    public Component getComponent(ItemStack item) {
        if (this.network == null) {
            return Component.m_237115_((String)"item.cbc_ballistics.network_manager.no_network");
        }
        if (this.selected != null) {
            return Component.m_237115_((String)"item.cbc_ballistics.network_manager.selected").m_130946_("" + this.selected.getId());
        }
        return Component.m_237115_((String)"item.cbc_ballistics.network_manager.no_selected");
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        this.cooldown = Math.max(0, this.cooldown - 1);
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == this && this.cooldown <= 0 && level != null && level.f_46443_ && this.network != null) {
            this.network.line(level, true);
            this.cooldown = 5;
        }
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (this.network != null) {
            this.network.appendForTooltip(pTooltipComponents);
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.cbc_ballistics.network_manager.no_network"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void syncToClient(Player player) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> ModMessages.sendToPlayer(new SyncManagerItemS2CPacket(this.network, this.selected), (ServerPlayer)player));
    }
}

