/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.item.custom;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.felis.cbc_ballistics.block.entity.ArtilleryCoordinatorBlockEntity;
import net.felis.cbc_ballistics.entity.model.RadioModel;
import net.felis.cbc_ballistics.item.RadioMaterial;
import net.felis.cbc_ballistics.item.custom.RangefinderItem;
import net.felis.cbc_ballistics.networking.ModMessages;
import net.felis.cbc_ballistics.networking.packet.artilleryCoordinator.OpenCoordinatorC2SPacket;
import net.felis.cbc_ballistics.networking.packet.radio.SendRadioDataC2SPacket;
import net.felis.cbc_ballistics.screen.Artillery_CoordinatorInterface;
import net.felis.cbc_ballistics.util.KeyBinding;
import net.felis.cbc_ballistics.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadioItem
extends ArmorItem {
    private byte cooldown = 0;

    public RadioItem(Item.Properties pProperties) {
        super((ArmorMaterial)new RadioMaterial(), ArmorItem.Type.CHESTPLATE, pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pHand));
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        if (pContext.m_43724_() == InteractionHand.MAIN_HAND && !level.f_46443_) {
            CompoundTag itemTag = pContext.m_43722_().m_41784_();
            BlockEntity blockEntity = level.m_7702_(pContext.m_8083_());
            if (blockEntity instanceof ArtilleryCoordinatorBlockEntity) {
                ArtilleryCoordinatorBlockEntity network = (ArtilleryCoordinatorBlockEntity)blockEntity;
                CompoundTag tag = new CompoundTag();
                tag.m_128385_("pos", Utils.blockPosToArray(network.m_58899_()));
                tag.m_128359_("network_id", network.getNetwork_id());
                itemTag.m_128365_("network", (Tag)tag);
            } else {
                itemTag.m_128473_("network");
            }
        }
        return super.m_6225_(pContext);
    }

    public boolean m_5812_(ItemStack pStack) {
        CompoundTag tags = pStack.m_41784_();
        return tags.m_128441_("network");
    }

    public boolean openRadio(ItemStack stack) {
        if (!this.m_5812_(stack)) {
            return false;
        }
        CompoundTag tag = stack.m_41783_().m_128469_("network");
        BlockPos pos = Utils.arrayToBlockPos(tag.m_128465_("pos"));
        ModMessages.sendToServer(new OpenCoordinatorC2SPacket(pos, tag.m_128461_("network_id")));
        return true;
    }

    public void sendTarget(ItemStack stack, String target) {
        if (!this.m_5812_(stack)) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128441_("network")) {
            tag.m_128359_("target", target);
            tag = tag.m_128469_("network");
            BlockPos pos = Utils.arrayToBlockPos(tag.m_128465_("pos"));
            ModMessages.sendToServer(new SendRadioDataC2SPacket(target, tag.m_128461_("network_id"), pos));
        }
    }

    public void receiveData(ItemStack stack, CompoundTag tag) {
        stack.m_41784_().m_128365_("network_data", (Tag)tag);
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        if (slotIndex == 38) {
            this.cooldown = (byte)Math.max(0, this.cooldown - 1);
            if (this.cooldown <= 0) {
                this.cooldown = (byte)5;
                CompoundTag tags = stack.m_41784_();
                ItemStack pStack = player.m_21120_(InteractionHand.MAIN_HAND);
                if (pStack.m_41720_() instanceof RangefinderItem && pStack.m_41784_().m_128461_("results").equals(tags.m_128461_("target")) && tags.m_128441_("network_data")) {
                    new Artillery_CoordinatorInterface(tags.m_128469_("network_data")).renderSolutions(level);
                }
            }
        }
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                HumanoidModel armourModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new RadioModel<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)RadioModel.LAYER_LOCATION)).BODY, "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                return armourModel;
            }
        });
    }

    public boolean isRepairable(ItemStack stack) {
        return super.isRepairable(stack);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "cbc_ballistics:textures/item/radio.png";
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"item.cbc_ballistics.radio_item.key_bind1").m_7220_(KeyBinding.OPEN_RADIO_KEY.getKey().m_84875_()).m_7220_((Component)Component.m_237115_((String)"item.cbc_ballistics.radio_item.key_bind2")));
        CompoundTag tags = pStack.m_41784_();
        if (tags.m_128441_("network")) {
            CompoundTag net = tags.m_128469_("network");
            pTooltipComponents.add((Component)Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.network").m_130946_(net.m_128461_("network_id")).m_7220_((Component)Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.at")).m_130946_(Utils.formatPos(net.m_128465_("pos"))));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

