/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.item.custom;

import com.google.common.collect.Multimap;
import java.util.List;
import net.felis.cbc_ballistics.config.CBC_BallisticsCommonConfigs;
import net.felis.cbc_ballistics.entity.custom.DetectingProjectile;
import net.felis.cbc_ballistics.item.custom.RadioItem;
import net.felis.cbc_ballistics.networking.ModMessages;
import net.felis.cbc_ballistics.networking.packet.SendRangeFinderC2SPacket;
import net.felis.cbc_ballistics.util.IHaveData;
import net.felis.cbc_ballistics.util.ParticleHelper;
import net.felis.cbc_ballistics.util.Utils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RangefinderItem
extends Item
implements IHaveData {
    public RangefinderItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public int m_8105_(ItemStack pStack) {
        return 1200;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.SPYGLASS;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        pPlayer.m_5496_(SoundEvents.f_144231_, 1.0f, 1.0f);
        pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pUsedHand);
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        this.stopUsing(pLivingEntity);
        return pStack;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        this.stopUsing(pLivingEntity);
    }

    private void stopUsing(LivingEntity pUser) {
        pUser.m_5496_(SoundEvents.f_144232_, 1.0f, 1.0f);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (pStack.m_41783_() != null) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.cbc_ballistics.rangefinder.results").m_130946_(pStack.m_41783_().m_128461_("results")));
        }
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.cbc_ballistics.rangefinder.shift_down.one").m_7220_((Component)Component.m_237113_((String)((Integer)CBC_BallisticsCommonConfigs.RANGEFINDER_MAX_RANGE.get()).toString()).m_7220_((Component)Component.m_237115_((String)"tooltip.cbc_ballistics.rangefinder.shift_down.two"))));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.cbc_ballistics.rangefinder"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    @Override
    public Component getComponent(ItemStack item) {
        if (item.m_41783_() == null) {
            return Component.m_237119_();
        }
        return Component.m_237113_((String)item.m_41783_().m_128461_("results"));
    }

    public void rangeFind(ItemStack item, Player player) {
        item.m_41751_(new CompoundTag());
        Level level = player.m_9236_();
        Vec3 playerPos = new Vec3(player.m_20185_(), player.m_20188_() - (double)1.4E-45f, player.m_20189_());
        HitResult result = new DetectingProjectile.Detect(level, playerPos).range((Integer)CBC_BallisticsCommonConfigs.RANGEFINDER_MAX_RANGE.get()).simulate(player.m_146909_(), player.m_146908_(), 10.0f).getResults();
        if (result != null && result.m_6662_() != HitResult.Type.MISS) {
            playerPos = new Vec3(player.m_20185_(), player.m_20188_() - 0.5, player.m_20189_());
            Vec3 pos = new Vec3(0.0, 0.0, 0.0);
            Vec3 hitPos = new Vec3(0.0, 0.0, 0.0);
            if (result instanceof BlockHitResult) {
                BlockHitResult bh = (BlockHitResult)result;
                BlockPos blockPos = bh.m_82425_();
                pos = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                hitPos = bh.m_82425_().m_252807_();
            } else if (result instanceof EntityHitResult) {
                EntityHitResult eh = (EntityHitResult)result;
                hitPos = pos = eh.m_82443_().m_20191_().m_82399_();
            }
            ParticleHelper.line(level, playerPos, hitPos, ParticleHelper.Colour.RED, 0.5f);
            String target = Utils.formatPos(pos);
            item.m_41783_().m_128359_("results", target);
            ItemStack stack = player.m_150109_().m_36052_(2);
            Item item2 = stack.m_41720_();
            if (item2 instanceof RadioItem) {
                RadioItem radio = (RadioItem)item2;
                radio.sendTarget(stack, target);
            }
        } else {
            item.m_41783_().m_128359_("results", "Too far");
        }
        if (level.f_46443_) {
            ModMessages.sendToServer(new SendRangeFinderC2SPacket(item));
        }
    }
}

