/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.networking.packet;

import java.util.function.Supplier;
import net.felis.cbc_ballistics.block.entity.ArtilleryCoordinatorBlockEntity;
import net.felis.cbc_ballistics.networking.ClientHandler;
import net.felis.cbc_ballistics.util.Utils;
import net.felis.cbc_ballistics.util.artilleryNetwork.Director;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncManagerItemS2CPacket {
    private int[] data;

    public SyncManagerItemS2CPacket(ArtilleryCoordinatorBlockEntity net, Director sel) {
        int[] pos;
        this.data = new int[8];
        if (net != null) {
            this.data[0] = 1;
            pos = Utils.blockPosToArray(net.m_58899_());
            this.data[1] = pos[0];
            this.data[2] = pos[1];
            this.data[3] = pos[2];
        }
        if (sel != null) {
            this.data[4] = 1;
            pos = Utils.blockPosToArray(sel.getBlockEntity().m_58899_());
            this.data[5] = pos[0];
            this.data[6] = pos[1];
            this.data[7] = pos[2];
        }
    }

    private SyncManagerItemS2CPacket(int[] data) {
        this.data = data;
    }

    public SyncManagerItemS2CPacket(FriendlyByteBuf buf) {
        this(buf.m_130116_(8));
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130089_(this.data);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHandler.SyncManagerItem(this.data)));
        return true;
    }
}

