/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.networking.packet.artilleryCoordinator;

import java.util.function.Supplier;
import net.felis.cbc_ballistics.block.entity.ArtilleryCoordinatorBlockEntity;
import net.felis.cbc_ballistics.networking.ModMessages;
import net.felis.cbc_ballistics.networking.packet.artilleryCoordinator.OpenCoordinatorS2CPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class OpenCoordinatorC2SPacket {
    private BlockPos pos;
    private String network_id;

    public OpenCoordinatorC2SPacket(BlockPos pos, String network_id) {
        this.pos = pos;
        this.network_id = network_id;
    }

    public OpenCoordinatorC2SPacket(FriendlyByteBuf buf) {
        this(buf.m_130135_(), buf.m_130136_(5));
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130072_(this.network_id, 5);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ArtilleryCoordinatorBlockEntity block;
            ServerPlayer player = context.getSender();
            ServerLevel level = (ServerLevel)player.m_9236_();
            BlockEntity blockS = level.m_7702_(this.pos);
            if (blockS instanceof ArtilleryCoordinatorBlockEntity && (block = (ArtilleryCoordinatorBlockEntity)blockS).getNetwork_id().equals(this.network_id)) {
                ModMessages.sendToPlayer(new OpenCoordinatorS2CPacket(block, false), player);
            } else {
                ModMessages.sendToPlayer(new OpenCoordinatorS2CPacket(), player);
            }
        });
        return true;
    }
}

