/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.networking.packet.artilleryCoordinator;

import java.util.function.Supplier;
import net.felis.cbc_ballistics.block.entity.ArtilleryCoordinatorBlockEntity;
import net.felis.cbc_ballistics.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SendArtilleryNetworkInstructionC2SPacket {
    private byte instruction;
    private String value;
    private BlockPos pos;

    public SendArtilleryNetworkInstructionC2SPacket(BlockPos pos, byte instruction, String value) {
        this.pos = pos;
        this.instruction = instruction;
        this.value = value;
    }

    public SendArtilleryNetworkInstructionC2SPacket(FriendlyByteBuf buf) {
        this(buf.m_130135_(), buf.readByte(), buf.m_130277_());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.instruction);
        buf.m_130070_(this.value);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = (ServerLevel)player.m_9236_();
            BlockEntity blockS = level.m_7702_(this.pos);
            if (blockS instanceof ArtilleryCoordinatorBlockEntity) {
                ArtilleryCoordinatorBlockEntity block = (ArtilleryCoordinatorBlockEntity)blockS;
                switch (this.instruction) {
                    case 0: {
                        block.setTarget(this.value);
                        break;
                    }
                    case 1: {
                        block.target();
                        break;
                    }
                    case 2: {
                        block.setMode(ArtilleryCoordinatorBlockEntity.Mode.fromByte((byte)Utils.stringToInt(this.value)));
                        break;
                    }
                    case 3: {
                        block.fire();
                        break;
                    }
                    case 4: {
                        block.setNetwork_id(this.value);
                    }
                }
            }
        });
        return true;
    }
}

